/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
module javacomm.client {
  requires LGoodDatePicker;
  requires com.google.gson;
  requires java.vorbis.support;
  requires net.jpountz.lz4;
  requires org.apache.logging.log4j;
  requires org.glassfish.jersey.client;
  requires org.glassfish.jersey.media.multipart;
  requires pumpernickel;
  requires io.nayuki.flac;

  requires transitive babelfish;
  requires transitive jakarta.ws.rs;
  requires transitive jakarta.xml.bind;
  requires transitive java.datatransfer;
  requires transitive java.desktop;
  requires transitive java.xml;
  requires transitive nexuslib;
  requires transitive org.apache.tomcat.embed.websocket;
  requires transitive protocol;
  requires transitive uk.co.caprica.vlcj;
  requires transitive window.manager;

  exports net.javacomm.client.administer;
  exports net.javacomm.client.base;
  exports net.javacomm.client.chat;
  exports net.javacomm.client.config.schema;
  exports net.javacomm.client.environment;
  exports net.javacomm.client.filetransfer;
  exports net.javacomm.client.gui;
  exports net.javacomm.client.info;
  exports net.javacomm.client.iptv;
  exports net.javacomm.client.launcher;
  exports net.javacomm.client.mediaplayer;
  exports net.javacomm.client.phone;
  exports net.javacomm.client.resource;
  exports net.javacomm.client.screencaster;
  exports net.javacomm.client.telko;
  exports net.javacomm.client.websocket;

  opens net.javacomm.client.config.schema;
  opens net.javacomm.client.iptv to com.google.gson;
}
