/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.administer;

import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualButton;
import net.javacomm.multilingual.MultilingualLabel;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.transfer.TransferOdxModulPermission;
import net.javacomm.window.manager.Control;

public class JModul extends JPanel implements Babelfish {
  private final static Logger log = LogManager.getLogger(JModul.class);

  private static final long serialVersionUID = -3443289496392733363L;
  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();
  private JSeparator separator = new JSeparator();
  private MultilingualButton cerrarBoton = new MultilingualButton(KEY.BUTTON_SCHLIESSEN);
  private JPanel panSouth = new JPanel(new FlowLayout(FlowLayout.CENTER));
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);
  private JScrollModule scrollmodul = new JScrollModule();
  private MultilingualLabel labelCheckmark = new MultilingualLabel(KEY.LABEL_EIN_GESETZTER_HAKEN);

  public JModul() {
    setLayout(gridbag);


    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(12, 12, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(labelCheckmark, con);
    add(labelCheckmark);
    labelCheckmark.setHorizontalAlignment(SwingConstants.CENTER);

    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 1.0;
    con.weighty = 1.0;
    con.insets = new Insets(12, 12, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(scrollmodul, con);
    add(scrollmodul);
    scrollmodul.getVerticalScrollBar().setUnitIncrement(12);
    scrollmodul.getHorizontalScrollBar().setUnitIncrement(12);
    scrollmodul.addUpdateListener(new PropertyChangeListener() {

      @Override
      public void propertyChange(PropertyChangeEvent event) {
        changes.firePropertyChange(event);
      }

    });

    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(24, 12, 0, 12);
    con.anchor = GridBagConstraints.CENTER;
    gridbag.setConstraints(separator, con);
    add(separator);

    con.gridx = 0;
    con.gridy++;
    con.gridwidth = 1;
    con.gridheight = 1;
    con.fill = GridBagConstraints.NONE;
    con.weightx = 0.0;
    con.weighty = 0.0;
    con.insets = new Insets(12, 12, 12, 12);
    con.anchor = GridBagConstraints.EAST;
    gridbag.setConstraints(panSouth, con);
    add(panSouth);
    panSouth.add(cerrarBoton);
    cerrarBoton.addActionListener((event) -> {
      changes.firePropertyChange(JModul.class.getName(), Control.NULL, Control.CLOSE);
    });

  }



  public void addModulListener(PropertyChangeListener listener) {
    changes.addPropertyChangeListener(listener);
  }



  public void removeModulListener(PropertyChangeListener listener) {
    changes.removePropertyChangeListener(listener);
  }



  public void removeAllListener() {
    for (PropertyChangeListener pl : changes.getPropertyChangeListeners()) {
      removeModulListener(pl);
    }
    for (ActionListener al : cerrarBoton.getActionListeners()) {
      cerrarBoton.removeActionListener(al);
    }
    scrollmodul.removeAllListener();
  }



  public void setOdx(List<TransferOdxModulPermission> odxuser) {
    scrollmodul.setOdx(odxuser);
  }


  @Override
  public void setLanguage(ISO639 code) {
    scrollmodul.setLanguage(code);
    cerrarBoton.setLanguage(code);
    labelCheckmark.setLanguage(code);
  }

}
