/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.base;

/**
 * Der MausWrapper speichert die Mausposition, die er von NEWMOUSEPOINTER
 * erhält.
 */
public class MausWrapper {

  private int x, y;

  /**
   * Diese Mausposition.
   * 
   * @param x
   *          Koordinate
   * @param y
   *          Koordinate
   */
  public MausWrapper(int x, int y) {
    this.x = x;
    this.y = y;
  }



  /**
   * Hole die X-Koordninat.
   * 
   * @return X-Koordinate
   */
  public int getX() {
    return x;
  }



  /**
   * Hole die Y-Koordiante.
   * 
   * @return Y-Koordinate
   */
  public int getY() {
    return y;
  }

}
