/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.base;

import java.awt.event.KeyEvent;



/**
 * Mnemonics für die Shortcuts in der Menuführung.
 *
 * @author llange
 *
 */
public enum Mnemonics {

  DEUTSCH("Deutsch", KeyEvent.VK_D),
  SPANISCH("Español", KeyEvent.VK_E),
  ENGLISCH("English", KeyEvent.VK_E),
  ENTER("<ENTER>", KeyEvent.VK_E),
  FRANZOESISCH("Français", KeyEvent.VK_F),
  ITALIENISCH("Italiano", KeyEvent.VK_I),
  LINKS("Links", KeyEvent.VK_L),
  OBEN("<Oben>", KeyEvent.VK_O),
  PORTUGUES("Português", KeyEvent.VK_P),
  RECHTS("<Rechts>", KeyEvent.VK_R),
  RUSSISCH("русский", KeyEvent.VK_R),
  TUERKISCH("Türkçe", KeyEvent.VK_T),
  UNTEN("<Unten>", KeyEvent.VK_U);

  private int mnemonic;
  private String menutext;

  private Mnemonics(String menutext, int value) {
    this.menutext = menutext;
    mnemonic = value;
  }



  public int getMnemonic() {
    return mnemonic;
  }



  @Override
  public String toString() {
    return menutext;
  }

}
