/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.chat;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import javax.swing.JSeparator;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.nexuswob.gui.swing.JavacommInternalFrame;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualButton;
import net.javacomm.multilingual.MultilingualLabel;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



public class JForum extends JavacommInternalFrame implements Babelfish {

  private static final long serialVersionUID = -8317001680616899642L;
  public final static int WIDTH = 480;
  public final static int HEIGHT = 201;
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);
  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();
  private MultilingualLabel labelForum = new MultilingualLabel(KEY.LABEL_FORUM);
  private JSeparator separator = new JSeparator();
  private MultilingualButton buttonSchliessen = new MultilingualButton(KEY.BUTTON_SCHLIESSEN);
  private int minutos = 30;

  public JForum() {
    init();
  }



  public void addForumListener(PropertyChangeListener listener) {
    changes.addPropertyChangeListener(listener);
  }



  @Override
  public Dimension getMinimumSize() {
    return new Dimension(WIDTH - 40, HEIGHT);
  }



  void init() {

    setLayout(gridbag);

    final int leftMargin = 12;
    final int rightMargin = 12;
    final int marginTop = 12;
    final int marginBottom = 12;

    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 1.0;
    con.weighty = 0.0;
    con.insets = new Insets(marginTop, leftMargin, 0, rightMargin);
    con.anchor = GridBagConstraints.NORTH;

    add(labelForum, con);

    con.gridx = 0;
    con.gridy = 1;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.HORIZONTAL;
    con.weightx = 1.0;
    con.weighty = 0.0;
    con.insets = new Insets(24, leftMargin, 0, rightMargin);
    con.anchor = GridBagConstraints.CENTER;
    add(separator, con);

    con.gridx = 0;
    con.gridy = 2;
    con.gridwidth = 1;
    con.fill = GridBagConstraints.NORTH;
    con.weightx = 0.0;
    con.weighty = 1.0;
    con.insets = new Insets(12, leftMargin, marginBottom, rightMargin);
    con.anchor = GridBagConstraints.NORTHEAST;
    add(buttonSchliessen, con);
    buttonSchliessen.addActionListener((event) -> {
      try {
        setClosed(true);
      }
      catch (PropertyVetoException e) {}
    });

    addInternalFrameListener(new InternalFrameAdapter() {
      @Override
      public void internalFrameClosed(InternalFrameEvent event) {
        changes.firePropertyChange(JForum.class.getName(), Control.NULL, Control.CLOSE);
      }

    });

  }



  /**
   * Der Schwellenwert in der Textausgabe
   *
   *
   * @param value
   *              die Anzahl in Minuten
   */
  public void setMinuten(int value) {
    minutos = value;
  }



  public void removeAllListener() {
    for (PropertyChangeListener tmp : changes.getPropertyChangeListeners()) {
      removeForumListener(tmp);
    }

  }



  public void removeForumListener(PropertyChangeListener listener) {
    changes.removePropertyChangeListener(listener);
  }



  @Override
  public void setLanguage(ISO639 code) {
    buttonSchliessen.setLanguage(code);
    labelForum.setLanguage(code);
    String neuerText = labelForum.getText().replace("XXX", String.valueOf(minutos));
    labelForum.setText(neuerText);

  }

}
