/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.chat;

import java.awt.Color;
import net.javacomm.multilingual.schema.ISO639;



public interface Message {
  public final static int SWAP_COLOR = 1; // ist textformat change foregrounf with background
  public final static String EOT = "\004";

  /**
   * Zeilenumbrüche \u0004 werden nicht als Paragraph gezählt
   * 
   * @return
   */
  public int countParagraphs();

  @Deprecated
  public String[] getParagraphs();

  public int getTextformatMask();

  /**
   * Die eingehende Nachricht.
   * 
   * @return die empfangene Nachricht
   */
  public String getMessage();

  public String getNickname();

  public Color getBackgroundColor();

  public Color getForegroundColor();

  public long getXtime();

  public long getXdate();

  @Deprecated
  public String getMddsTime(long xtime);

  @Deprecated
  public String getMddsDate(long date);

  /**
   * Gib das aktuelle Datum im Landesformat zurück.
   * 
   * 
   * @param datetime
   *                 Tag und Zeit in Millis
   * @param iso
   *                 de, en, es ,it ...
   * @return Tag und Zeit werden im Landesformat zurückgegeben
   */
  public String getMddsDateTime(long datetime, ISO639 iso);

  /**
   * Gib das aktuelle Datum im Landesformat zurück.
   * 
   * @param datetime
   *                 Tag und Zeit in Millis
   * @return Tag und Zeit werden im Landesformat zurückgegeben
   */
  public String getMddsDateTime(long datetime);

  /**
   * Der Anwender kann eine Anlage mitsenden.
   * 
   * @return ein Dateiname
   */
  public String getFilename();

  /**
   * Die Dateigröße. Das Attribut ist ein Teil der Anlage
   * 
   * @return Größe in Bytes
   */
  public Long getFilesize();

  /**
   * Filenumber ist ein Datenbankschlüssel und ein Teil der Anlage.
   * 
   * @return ein Schlüssel
   */
  public Long getFilenumber();

}
