/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.launcher;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.javacomm.client.resource.Resource;



@SuppressWarnings("serial")
public class BarRenderer extends DefaultTableCellRenderer {

  @Override
  public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
      boolean hasFocus, int row, int column) {

    // log.info("row=" + row);

    if ((row % 2) == 0) {
      if (isSelected) {
        setBackground(Resource.JQUERY_BLAU);
        setForeground(Resource.JQUERY_HELLBLAU);
      }
      else {
        setBackground(Resource.JQUERY_BLAU); // Bar
        setForeground(Resource.JQUERY_BLAU);
      }
    }
    else {
      if (isSelected) {
        setBackground(Resource.JQUERY_YELLOW);
        setForeground(Color.BLACK);
      }
      else {
        setBackground(Resource.JQUERY_HELLBLAU);
        setForeground(Color.BLACK);
      }
    }

    setText(value.toString());
    return this;
  }

}
