/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.launcher;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.javacomm.multilingual.Babelfish;
import net.javacomm.multilingual.MultilingualButton;
import net.javacomm.multilingual.schema.ISO639;
import net.javacomm.multilingual.schema.KEY;
import net.javacomm.window.manager.Control;



/**
 * Diese Komponente ist der linke Teil von {@code JLauncher}. Sie enthält die
 * Subkomponent {@code JLauncherSelectRoom}.
 */
@SuppressWarnings("serial")
public class JLeftComponent extends JPanel implements Babelfish {

  private GridBagLayout gridbag = new GridBagLayout();
  private GridBagConstraints con = new GridBagConstraints();
  private MultilingualButton closeButton = new MultilingualButton(KEY.BUTTON_CLOSE_ALL_ROOMS);
  private JSeparator separator = new JSeparator();
  private PropertyChangeSupport changes = new PropertyChangeSupport(this);
  private JPanel dummy = new JPanel();

  public JLeftComponent(JLauncherSelectRoom selectRoom) {
    setLayout(gridbag);

    con.gridx = 0;
    con.gridy = 0;
    con.gridwidth = 2;
    con.insets = new Insets(0, 0, 0, 0);
    con.fill = GridBagConstraints.BOTH;
    con.anchor = GridBagConstraints.SOUTH;
    con.weightx = 1.0;
    con.weighty = 1.0;
    gridbag.setConstraints(selectRoom, con);
    add(selectRoom);

//    con.gridx = 0;
//    con.gridwidth = 1;
//    con.insets = new Insets(24, 0, 0, 0);
//    con.fill = GridBagConstraints.HORIZONTAL;
//    con.anchor = GridBagConstraints.SOUTHEAST;
//    con.weightx = 1.0;
//    con.weighty = 0.0;
//    gridbag.setConstraints(dummy, con);
//    add(dummy);

    con.gridx = 1;
    con.gridy++;
    con.gridwidth = 1;
    con.insets = new Insets(24, 24, 12, 24);
    con.fill = GridBagConstraints.HORIZONTAL;
    con.anchor = GridBagConstraints.SOUTHEAST;
    con.weightx = 0.0;
    con.weighty = 0.0;
    gridbag.setConstraints(separator, con);
    add(separator);

    con.gridx = 1;
    con.gridy++;
    con.gridwidth = 1;
    con.insets = new Insets(0, 0, 12, 24);
    con.fill = GridBagConstraints.NONE;
    con.anchor = GridBagConstraints.EAST;
    con.weightx = 0.0;
    con.weighty = 0.0;
    gridbag.setConstraints(closeButton, con);
    add(closeButton);

    closeButton.addActionListener(event -> {
      changes.firePropertyChange(JLeftComponent.class.getName(), Control.NULL, Control.CLOSE);
    });

  }



  public void addLeftComponentListener(PropertyChangeListener listener) {
    changes.addPropertyChangeListener(listener);
  }



  public void removeLeftComponentListener(PropertyChangeListener listener) {
    changes.removePropertyChangeListener(listener);
  }



  @Override
  public void setLanguage(ISO639 code) {
    closeButton.setLanguage(code);
  }

}
