/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.mediaplayer;

import java.util.EventObject;


/**
 * Der MediaPlayer l�st ein Ereignis aus.
 * 
 * @author llange
 *
 */
public class MediaPlayerEvent extends EventObject {

  /**
   * Events
   * 
   * 
   * @author llange
   *
   */
  public enum event {STARTED, PICTURE_COMPLETED, AUDIO, FINISHED};
  
  private static final long serialVersionUID = -498571883205835327L;
  private event id;
  private long timestamp;
  
  
  /**
   * 
   * @param source
   *                  das auslösende Objekt
   * @param timestamp
   *                  der auslösende Zeitpunkt
   */
  private MediaPlayerEvent(Object source, long timestamp) {
    super(source);
    this.timestamp = timestamp;
  }


  
  /**
   * 
   * @param source
   *                  das auslösende Objekt
   * @param id
   *                  das Ereignis
   * @param timestamp
   *                  der auslösende Zeitpunkt
   */
  public MediaPlayerEvent(Object source, event id, long timestamp) {
    this(source, timestamp);
    this.id = id;
  }

  
  
  /**
   * Welches Ereignis wurde ausgelöst?
   * 
   * @return
   */
  public event getId() {
    return id;
  }

  
  
  
  
  
  /**
   * Die bisher abgelaufene Zeit in einem Video.
   * 
   * @return ein Zeitpunkt in Mikrosekunden
   */
  public long getTimestamp() {
    return timestamp;
  }

  
  

}
