/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.phone;

/**
 * Wird geworfen, wenn eine Datei nicht lesbar ist. Die Datei könnte
 * beispielsweise ein Verzeichnis sein.
 * 
 * @author llange
 *
 */
public class CheckReadException extends RuntimeException {

  private static final long serialVersionUID = -613796437473778771L;

  public CheckReadException() {
    super();
  }



  public CheckReadException(String message) {
    super(message);
  }



  public CheckReadException(String message, Throwable t) {
    super(message, t);
  }



  public CheckReadException(Throwable t) {
    super(t);
  }

}
