/**
 *  Copyright © 2021-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.resource;

import java.awt.Color;



public final class Resource {

  public final static String PRE_PACKAGE = "/net/javacomm/client";
  public final static String TRUSTSTORE = PRE_PACKAGE + "/web/truststore";
  public final static String PACKGAE = PRE_PACKAGE + "/resource/";
  public final static String CONFIG_SCHEMA = PRE_PACKAGE + "/config/schema/config.xsd";

  public final static String CONNECT = PACKGAE + "Cnect.gif";
  public final static String PAPERCLIP_16x22 = PACKGAE + "goldpaperclip_16x22.png";
  public final static String SIGNIN_28x28 = PACKGAE + "signin_28x28.png";
  public final static String ADIOS_28x28 = PACKGAE + "adios_28x28.png";
  public final static String PERSONAL = PACKGAE + "who_25x25.png";
  public final static String FARBSCHEMA_26x26 = PACKGAE + "color-wheel-icon_26x26.png";
//  public final static String LAUNCH = PACKGAE + "doorpaint_18x26.png";
  public final static String PRIVAT_26x26 = PACKGAE + "privat_26x26.png";
  public final static String FOOTPRINT = PACKGAE + "foot_38x48.png";
  public final static String CLEAR_18x18 = PACKGAE + "clear.png";
  public final static String THUMBS_32x30 = PACKGAE + "thumbs-up_32x30.png";
  public final static String UPLOAD_CLOUD_32x32 = PACKGAE + "upload_cloud_32x32.png";
  public final static String DOWNLOAD_CLOUD_32x32 = PACKGAE + "download_cloud_32x32.png";

//  public final static String CHATFILE_DOWNLOAD = PACKGAE + "software-update_15x16.png";
  public final static String CONFERENCE_23x26 = PACKGAE + "speakerphone_23x26.png";

  // ODX
  public final static String CHECK = PACKGAE + "formula_25x26.png";
  public final static String CHECK_OK = PACKGAE + "check-yes_30x26.png";
  public final static String CHECK_NOK = PACKGAE + "check-no_30x26.png";
  public final static String EMPTY_CHECKMARK = PACKGAE + "empty-check-box_24x24.png";

  // ODX

  // MauseCursor
  public final static String DUKEMAUS = PACKGAE + "duke_maus_32x32.png";
  public final static String POWERBUTTON_52x52 = PACKGAE + "Power_On_Off_Switch_52x52.png";

  public final static String LEFT_ARROW_34x26 = PACKGAE + "blue-arrow_34x26.png";

  public final static String FULLSCREEN_58x52 = PACKGAE + "fullscreen_58x52.png";
  public final static String FULLSCREEN_29x26 = PACKGAE + "fullscreen_29x26.png";
  public final static String DOWNLOAD_46x48 = PACKGAE + "software-update_46x48.png";

  public final static String AUFKLAPPEN_29x26 = PACKGAE + "aufklappen_29x26.png";
  public final static String REMOTECURSOR = PACKGAE + "mouse_right_click_4_32x32.png";

  public final static String PROJEKTOR_34x26 = PACKGAE + "projector_43x26.png";
  public final static String TVTEST_41x26 = PACKGAE + "tv-test-screen_41x26.png";
  public final static String ROBOT_TV_299x264 = PACKGAE + "robot-on-tv_299x264.png";
  public final static String ROBOT_TV_30x26 = PACKGAE + "robot-on-tv_30x26.png";

  public final static String LAUTER_32x26 = PACKGAE + "icon_Volume_plus_32x26.png";
  public final static String LEISER_32x26 = PACKGAE + "icon_Volume_minus_32x26.png";

  public final static String FRAGEZEICHEN_ORANGE_48x48 = PACKGAE + "fragezeichen_orange_48x48.png";
  public final static String FRAGEZEICHEN_46x48 = PACKGAE + "fragezeichen_46x48.png";
  public final static String SCREENOPEN_25x26 = PACKGAE + "screen_open_25x26.png";
  public final static String SCREENLOCK_25x26 = PACKGAE + "system-lock-screen_25x26.png";

  public final static String CONSENT_39x26 = PACKGAE + "handshake_39x26.png";
  public final static String SHARE_36x26 = PACKGAE + "Magnify-clip_36x26.png";

  public final static String PHONE = PACKGAE + "phone.png";
  public final static String PHONE_RING = PACKGAE + "phone_ring_25x18.png";
  public final static String FTP = PACKGAE + "peer2peer25x24.png";
  public final static String PACKAGE_MULTIMEDIA = PACKGAE + "mp3_18x25.png";
  public final static String SHUFFLE = PACKGAE + "ballerina_18x26.png";
  public final static String DVD_26x26 = PACKGAE + "dvd_26x26.png";
  public final static String DEUTSCH_39x26 = PACKGAE + "germany_39x26.png";
  public final static String ENGLISH_39x26 = PACKGAE + "union-jack_39x26.png";
  public final static String FRANCE_39x26 = PACKGAE + "france_39x26.png";
  public final static String SPAIN_39x26 = PACKGAE + "spain_39x26.png";
  public final static String ITALIENISCH_39x26 = PACKGAE + "italian_39x26.png";
  public final static String TURKEY_39x26 = PACKGAE + "turkey_39x26.png";
  public final static String RUSIA_39x26 = PACKGAE + "rusia_39x26.png";
  public final static String PORTUGAL_39x26 = PACKGAE + "portugal_39x26.png";

  public final static String SPRACHE_20x26 = PACKGAE + "Gold_Speech_Bubble_20x26.png";

  public final static String TITEL = PACKGAE + "film_29x26.png";

  public final static String JUKEBOX = PACKGAE + "jukebox_16x26.png";
  public final static String LEEREN = PACKGAE + "Gerald_G_45_RPM_Records_35x26.png";

  public final static String UNMUTE_26x26 = PACKGAE + "unmute_26x26.png";
  public final static String MUTE_26x26 = PACKGAE + "mute_26x26.png";
  public final static String FENSTER_IM_HINTERGRUND = PACKGAE + "toBack_29x26.png";
  public final static String SCHWARZE_LISTE = PACKGAE + "check-list_21x26.png";
  public final static String ADMINISTRATOR = PACKGAE + "admin_27x26.png";

  public final static String MICROPHONE = PACKGAE + "telephone-connection_40x25.png";
  public final static String RINGTONE = PACKGAE + "amistades_00_27.ogg";
  public final static String DIALTONE = PACKGAE + "dialing.ogg";
  public final static String OFFHOOK = PACKGAE + "uk_dial_tone.ogg";
  public final static String BUSYTONE = PACKGAE + "busytone.ogg";
  public final static String VORHANG = PACKGAE + "fullscreen_29x26.png";

  public final static String AUDIO_20X27 = PACKGAE + "audio20x27.png";
  public final static String FRAME_22X22 = PACKGAE + "frame22x22.png";
  public final static String LOGO_16x16 = PACKGAE + "javacomm_16x16.png";
  public final static String ONLINEBOOK = PACKGAE + "onlinebook.png";
  public final static String WEBCAM = PACKGAE + "webcam.png";
  public final static String MULTIMEDIA = PACKGAE + "multimedia_26x26.png";
  public final static String TAPETE_ANKLEBEN_25x25 = PACKGAE + "display_wallpaper_26x26.png";
  public final static String TAPETE_ABREISSEN_24x26 = PACKGAE + "monitor_loeschen_26x26.png";
  public final static String NEXUS = PACKGAE + "nexus.gif";
  public final static String NEXUS32 = PACKGAE + "nexus32x32.png";
  public final static String LICENSE = PACKGAE + "license.txt";
  public final static String INFO_16X16 = PACKGAE + "info_red_25x25.png";

  public final static String ANRUFEN_37X25 = PACKGAE + "man-lady-talking_37x25.png";
  public final static String ABNEHMEN = PACKGAE + "phone_abnehmen.png";
  public final static String AUFLEGEN = PACKGAE + "phone_aufgelegt_25x25.png";
  public final static String ROTARY = PACKGAE + "Rotary_Dialer_25x25.png";
  public final static String FORBIDDEN_MICROPHONE = PACKGAE + "mikro_25x25.png";
  public final static String MICROPHONE_CONFERENCE = PACKGAE + "no_mikro_25x25.png";
  public final static String DESKTOP_ANIMATED_25x25 = PACKGAE + "film_25x25.gif";
  public final static String DESKTOP_25x25 = PACKGAE + "desktop_25x25.png";
  public final static String ONLINE_26x26 = PACKGAE + "online_26x26.png";
  public final static String OFFLINE_26x26 = PACKGAE + "offline-cloud-kreuz_26x26.png";

  public final static String MODEM_AIF = PACKGAE + "modem.aif";
  public final static String DIALOG_WAVE = PACKGAE + "KDE_Dialog_Appear.wav";
  public final static String POP_WAVE = PACKGAE + "pop.wav";
  public final static String WINDOW_LIST = PACKGAE + "blue-open-window_25.png";

  public final static String WINDOW_NEW = PACKGAE + "closed-blue_28x25.png";
  public final static String WORLD = PACKGAE + "Embrace_the_World_24x26.png";

  public final static String XFMAIL_16X16 = PACKGAE + "xfmail16x16.png";
  public final static String MULTIMEDIA_16X16 = PACKGAE + "multimedia16x16.png";
  public final static String WEBCAM_16X16 = PACKGAE + "webcam16x16.png";
  public final static String Y2_KUSER = PACKGAE + "y2_kuser.png";
  public final static String HELPBOOK_OPEN = PACKGAE + "helpbook_open.png";
  public final static String TELEFONEINRICHTEN_42x26 = PACKGAE + "telephone_42x26.png";
  public final static String TELEFONEINRICHTEN_77x64 = PACKGAE + "telephone-network_77x64.png";

  public final static String TELEFONKONFERENZ_31X26 = PACKGAE + "telephone-network_31x26.png";
  public final static String TELKO_TEILNEHMEN_23X26 = PACKGAE + "girl-add_23x26.png";
  public final static String TELKO_ORGANISIEREN_23X26 = PACKGAE + "telko_organisieren_23x26.png";
  public final static String TELKO_ERSTELLEN_18x26 = PACKGAE + "telko_erstellen_18x26.png";
  public final static String TELKO_FRAME_ICON_11x16 = PACKGAE + "telefonkonferenz_erstellen_11x16.png";

  public final static String MULTIMEDIA_3 = PACKGAE + "multimedia3.png";
  public final static String PRIVAT = PACKGAE + "privat_100x100.png";
  public final static String PERSONAL_16X16 = PACKGAE + "personal16x16.png";
  public final static String ADMINISTRATOR_16X16 = PACKGAE + "admin_16x16.png";
  public final static String LOCK = PACKGAE + "lock.png";
  public final static String UNLOCK = PACKGAE + "unlock.png";
  public final static String DUKEPLUG = PACKGAE + "dukeplug_85x99.png";
  public final static String DEFAULT_WALLPAPER = PACKGAE + "Star_7_and_Duke_369x600.png";
  public final static String PAUSENRAUM = PACKGAE + "pausenraum_26x26.png";
  public final static String GNOME = PACKGAE + "gnome-die6.png";
  public final static String TOP = PACKGAE + "top.png";
  public final static String BOTTOM = PACKGAE + "bottom.png";
  public final static String UP = PACKGAE + "up.png";
  public final static String DOWN = PACKGAE + "down.png";
  public final static String REMOTE = PACKGAE + "radio_wireless_tower_21x25.png";
  public final static String GNOME_DICE = PACKGAE + "gnome-die1.png";
  public final static String LOGIN_26x26 = PACKGAE + "iniciar_26x26.png";
  public final static String NO_CELL_PHONE_25X25 = PACKGAE + "no_talking_25x25.png";
  public final static String TIME_25X25 = PACKGAE + "time_25x25.png";
  public final static String DATETIME_25X25 = PACKGAE + "april29_23x25.png";
  public final static String DISMISS_25X25 = PACKGAE + "dismiss_25x25.png";
  public final static String RED_CHECKMARK = PACKGAE + "red_checkmark.png";
  public final static String GREENGO_50x23 = PACKGAE + "pink_thumbs_up_25x25.png";
  public final static String NICKNAME = PACKGAE + "whale100x92.png";
  public final static String STATUS = PACKGAE + "status50x22.png";
  public final static String ONLINE = PACKGAE + "online-arrows20x25.png";
  public final static String CLOSE_BLUE = PACKGAE + "close_blue25x25.png";
  public final static String ENTER = PACKGAE + "followme49x74.png";
  public final static String CONFIGURE = PACKGAE + "configuration25x25.png";
  public final static String SERVERSTART = PACKGAE + "application-startup32x29.png";
  public final static String SHUTDOWN = PACKGAE + "application-shutdown32x29.png";
//  public final static String GPL3_ICON = PACKGAE + "320px-GPLv3_Logo_50x25.png";
  public final static String CALL = PACKGAE + "Telephone_receiver_25x23.png";
  public final static String TELEFON_PICTURE = PACKGAE + "man-lady-talking_88x60.png";
  public final static String EMBRACE_THE_WORLD = PACKGAE + "embrace_the_world_42x45.png";
  public final static String PAUSENRAUM45 = PACKGAE + "pausenraum_45x45.png";
  public final static String LOCK_OPEN = PACKGAE + "lock_open_29x25.png";

  public final static String OPEN_26x26 = PACKGAE + "open_green_26x26.png";

  public final static String PADLOCK = PACKGAE + "access_26x26.png";
  public final static String GRUPPENRAUM = PACKGAE + "group_49x52.png";

  public final static String EXPORT = PACKGAE + "load25x23.png";
  public final static String IMPORT = PACKGAE + "save25x23.png";
  public final static String FILECLOSE = PACKGAE + "fileclose.png";
  public final static String UP16 = PACKGAE + "Up16.gif";
  public final static String SEARCH = PACKGAE + "searchfile25x25.png";
  public final static String REMOVE = PACKGAE + "Trash_Bins19x25.png";
  public final static String REFRESH = PACKGAE + "recycle-chrome_25x25.png";
  public final static String FIND = PACKGAE + "binoculars25x17.png";
  public final static String BROWN_CLOSE_BUTTON = PACKGAE + "brown_closebutton_25x25.png";
  public final static String SMALL_GREEN_CHECK = PACKGAE + "small_green_check25x25.png";
  public final static String SMALL_RED_CHECK25x25 = PACKGAE + "small_red_check25x25.png";
  public final static String ANONYMOUS = PACKGAE + "codeman_45.png";
  public final static String CRYPTO_32x32 = PACKGAE + "crypto-chip_32x32.png";
  public final static String CRYPTO_26x26 = PACKGAE + "crypto-chip_26x26.png";
  public final static String REDPADLOCK = PACKGAE + "red-padlock_25x25.png";
  public final static String BESPRECUNGSRAUM_35x26 = PACKGAE + "meeting_35x26.png";
  public final static String BESPRECUNGSRAUM_71x52 = PACKGAE + "meeting_71x52.png";
  public final static String GRUPPENRAUM_25x26 = PACKGAE + "group_25x26.png";
  public final static String WIRE = PACKGAE + "wire_64x16.png";
  public final static String LEFTARROW_25x26 = PACKGAE + "left_arrow_25x26.png";

  public final static String RIGHTARROW_25x26 = PACKGAE + "right_arrow_25x26.png";
  public final static String MP3PLAYER = PACKGAE + "audio-x-generic_25x25.png";

  public final static String MEDIASTART = PACKGAE + "play_orange_32x32.png";
  public final static String MEDIAPAUSE = PACKGAE + "pause_orange_32x32.png";
  public final static String MEDIA_SKIP_BACKWARD = PACKGAE + "skip_backward_orange_32x32.png";
  public final static String EJECT_32x32 = PACKGAE + "eject_32x32.png";

  public final static String POPUP_MEDIASTART = PACKGAE + "start_orange_player_26x26.png";
  public final static String POPUP_MEDIAPAUSE = PACKGAE + "pause_orange_26x26.png";
  public final static String POPUP_BACKWARD = PACKGAE + "rewind_orange_26x26.png";
  public final static String POPUP_FORWARD = PACKGAE + "forward_orange_26x26.png";

  public final static String POPUP_SCHRITTWEITE = PACKGAE + "time_26x26.png";

  public final static String ICON_VOLUME_PLUS = PACKGAE + "icon_Volume_plus50x41.png";
  public final static String ICON_VOLUME_MINUS = PACKGAE + "icon_Volume_minus50x41.png";
  public final static String ICON_SPEAKER_ON = PACKGAE + "icon_Speaker_on40x40.png";
  public final static String ICON_SPEAKER_OFF = PACKGAE + "icon_Speaker_off40x40.png";
  public final static String ICON_OPEN_FILE = PACKGAE + "icon_open_File50x50.png";
  public final static String ICON_OPEN_FILE_PRESSED = PACKGAE + "icon_open_File_pressed50x50.png";
//  public final static String GPL3 = PACKGAE + "gplv3-159x64.png";
  public final static String MPL2_ICON = PACKGAE + "37x26px-Mozilla_dinosaur_head_logo.png";
  public final static String MOZILLA = PACKGAE + "96px-Mozilla_dinosaur_head_logo.png";
  public final static String MULTIMEDIA_CHIP = PACKGAE + "multimedia_chip_200x200.png";
  public final static String BLACK_CLOSE_BUTTON = PACKGAE + "black_closed_24x24.png";
  public final static String NEXT_TITLE = PACKGAE + "next_titel_26x26.png";

  public final static String RECORDING_BUTTON = PACKGAE + "recodring_25x25.png";
  public final static String RECORDING_STOP_BUTTON = PACKGAE + "recording_stop_25x25.png";
  public final static String NO_CELL_PHONE = PACKGAE + "no_cellphone_25x25.png";

  public final static String FONTNAME_THIN = "Nunito-Light";
  public final static String FONTNAME_REGULAR = "Nunito-Regular";
  public final static String FONTNAME_BOLD = "Nunito-Bold";

  public final static String TRUETYPE_THIN = PACKGAE + FONTNAME_THIN + ".ttf";
  public final static String TRUETYPE_REGULAR = PACKGAE + FONTNAME_REGULAR + ".ttf";
  public final static String TRUETYPE_BOLD = PACKGAE + FONTNAME_BOLD + ".ttf";

  public final static int FELD_LEN_ROOM = 16;

  // JQUERY
  public static final Color JQUERY_HELLBLAU = new Color(218, 212, 247);
  public static final Color JQUERY_ORANGE = new Color(252, 203, 26);
  public static final Color JQUERY_TEXTBRAUN = new Color(52, 43, 9);
  public static final Color JQUERY_BLAU = new Color(68, 36, 214);
  public static final Color JQUERY_BRAUN = new Color(184, 148, 20);
  public static final Color JQUERY_HOMEPAGE = new Color(121, 85, 72);
  public static final Color JQUERY_RED = new Color(254, 39, 18);
  public static final Color JQUERY_YELLOW = new Color(254, 254, 51);
  public static final Color JQUERY_GREEN = new Color(81, 174, 48);
  public static final Color JQUERY_GREEN_YELLOW = new Color(127, 255, 0);
  public static final Color JQUERY_ERDBEERE = new Color(247, 169, 195);
  public static final Color JQUERY_MOKKA = new Color(217, 217, 217);
  public static final Color JQUERY_VANILLE = new Color(255, 249, 185);
  public static final Color JQUERY_LEMON = new Color(242, 240, 228);
//  public static final Color JQUERY_LEMON = new Color(0, 114, 67); //Minze ok

  private Resource() {}

}
