/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.client.screencaster;

import java.awt.image.BufferedImage;
import java.util.EventObject;

public class ImageReceiverEvent extends EventObject {

  private static final long serialVersionUID = -3897051129914601693L;
  private BufferedImage picture;

  /**
   * Ein Event wird erstellt.
   * 
   * @param source
   *               der Auslöser
   */
  public ImageReceiverEvent(Object source) {
    super(source);
  }



  /**
   * Ein Event wird gemeldet.
   * 
   * @param source
   *                der Auslöser
   * @param picture
   *                ein Bild
   */
  public ImageReceiverEvent(Object source, BufferedImage picture) {
    this(source);
    this.picture = picture;
  }




  /**
   * Alle Bilddaten werden einem Event zugeordnet.
   * 
   * @param picture
   *                ein Bild
   */
  public void setImageReceiverEvent(BufferedImage picture) {
    this.picture = picture;
  }



  /**
   * Ein Bild wird zurückgegeben. Das Format ist JPG.
   * 
   * @return ein Bild im JPG-Format
   */
  public BufferedImage getPicture() {
    return picture;
  }



}
