/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

import java.util.Date;
import net.javacomm.protocol.Entry;
import net.javacomm.protocol.Lifetime;
import net.javacomm.protocol.Roomtype;



public class Chat {

  private String chatid;
  private String groupid;
  private String ownwer;
  private String uid;
  private Date geburt;
  private Lifetime lifetime;
  private Roomtype roomtype;
  private Entry entry;

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    Chat other = (Chat) obj;
    if (chatid == null) {
      if (other.chatid != null) return false;
    }
    else if (!chatid.equals(other.chatid)) return false;
    if (entry != other.entry) return false;
    if (geburt == null) {
      if (other.geburt != null) return false;
    }
    else if (!geburt.equals(other.geburt)) return false;
    if (groupid == null) {
      if (other.groupid != null) return false;
    }
    else if (!groupid.equals(other.groupid)) return false;
    if (lifetime != other.lifetime) return false;
    if (ownwer == null) {
      if (other.ownwer != null) return false;
    }
    else if (!ownwer.equals(other.ownwer)) return false;
    if (roomtype != other.roomtype) return false;
    if (uid == null) {
      if (other.uid != null) return false;
    }
    else if (!uid.equals(other.uid)) return false;
    return true;
  }



  public String getChatid() {
    return chatid;
  }



  public Entry getEntry() {
    return entry;
  }



  public Date getGeburt() {
    return geburt;
  }



  public String getGroupid() {
    return groupid;
  }



  public Lifetime getLifetime() {
    return lifetime;
  }



  public String getOwnwer() {
    return ownwer;
  }



  public Roomtype getRoomtype() {
    return roomtype;
  }



  public String getUid() {
    return uid;
  }



  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((chatid == null) ? 0 : chatid.hashCode());
    result = prime * result + ((entry == null) ? 0 : entry.hashCode());
    result = prime * result + ((geburt == null) ? 0 : geburt.hashCode());
    result = prime * result + ((groupid == null) ? 0 : groupid.hashCode());
    result = prime * result + ((lifetime == null) ? 0 : lifetime.hashCode());
    result = prime * result + ((ownwer == null) ? 0 : ownwer.hashCode());
    result = prime * result + ((roomtype == null) ? 0 : roomtype.hashCode());
    result = prime * result + ((uid == null) ? 0 : uid.hashCode());
    return result;
  }



  public void setChatid(String chatid) {
    this.chatid = chatid;
  }



  public void setEntry(Entry entry) {
    this.entry = entry;
  }



  public void setGeburt(Date geburt) {
    this.geburt = geburt;
  }



  public void setGroupid(String groupid) {
    this.groupid = groupid;
  }



  public void setLifetime(Lifetime lifetime) {
    this.lifetime = lifetime;
  }



  public void setOwnwer(String ownwer) {
    this.ownwer = ownwer;
  }



  public void setRoomtype(Roomtype roomtype) {
    this.roomtype = roomtype;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }

}
