/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

import java.time.ZonedDateTime;
import net.javacomm.protocol.Agent;



/**
 * Die Tabelle TB_ONLINE.
 */
public class Online {

  private String uid;
  private String session;
  private Agent agent;
  private Boolean onBusy;
  private String aes;
  private ZonedDateTime keepalive;
  private ZonedDateTime since;

  public String getAes() {
    return aes;
  }



  public Agent getAgent() {
    return agent;
  }



  /**
   * Wann hat der User zuletzt ein Lebenszeichen gesendet?
   * 
   * @return Datum + Uhrezit + Zeitzone
   */
  public ZonedDateTime getKeepalive() {
    return keepalive;
  }



  /**
   * Ist der User am telefonieren?
   * 
   * @return {@code true}, wenn er telefoniert
   */
  public Boolean getOnBusy() {
    return onBusy;
  }



  public String getSession() {
    return session;
  }



  /**
   * Wann hat sich der User angemeldet?
   * 
   * @return Datum + Uhrezit + Zeitzone
   */
  public ZonedDateTime getSince() {
    return since;
  }



  /**
   * Die Benutzerkennung aus der TB_USER.
   * 
   * @return 8-stellige Benutzerkennung
   */
  public String getUid() {
    return uid;
  }



  public void setAes(String aes) {
    this.aes = aes;
  }



  public void setAgent(Agent agent) {
    this.agent = agent;
  }



  /**
   * Der Anwender schickt ein Lebenszeichen.
   * 
   * @param keepalive
   *                  Datum + Uhrezit + Zeitzone
   */
  public void setKeepAlive(ZonedDateTime keepalive) {
    this.keepalive = keepalive;
  }



  /**
   * Der Anwender könnte telefonieren.
   * 
   * @param onBusy
   *               {@code true}, wenn er telefoniert
   */
  public void setOnBusy(Boolean onBusy) {
    this.onBusy = onBusy;
  }



  public void setSession(String session) {
    this.session = session;
  }



  /**
   * Seit diesem Aufruf ist der Anwender angemeldet.
   * 
   * @param since
   *              Datum + Uhrezit + Zeitzone
   */
  public void setSince(ZonedDateTime since) {
    this.since = since;
  }



  /**
   * Die Benutzerkennung aus der TB_USER.
   * 
   * @param uid
   *            8-stellige Benutzerkennung
   */
  public void setUid(String uid) {
    this.uid = uid;
  }

}
