/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

/**
 * Die Klasse bildet die Tabelle TB_PHONE ab.
 * 
 * @author lromero
 *
 */
public class Phone {

  private String uid;
  private String ip;
  private int port;
  private boolean onCall;
  private boolean onBusy;
  private int volume;

  public Phone() {}



  public String getUid() {
    return uid;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public String getIp() {
    return ip;
  }



  public void setIp(String ip) {
    this.ip = ip;
  }



  public int getPort() {
    return port;
  }



  public void setPort(int port) {
    this.port = port;
  }



  public boolean isOnCall() {
    return onCall;
  }



  public void setOnCall(boolean onCall) {
    this.onCall = onCall;
  }



  public boolean isOnBusy() {
    return onBusy;
  }



  public void setOnBusy(boolean onBusy) {
    this.onBusy = onBusy;
  }



  public int getVolume() {
    return volume;
  }



  public void setVolume(int volume) {
    this.volume = volume;
  }

}
