/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.database.entity;

/**
 * Diese Klasse bildet die Tabelle TB_PRIVATE_CHATFILE ab.
 */
public class PrivateChatfile {

  private Long anlage;
  private String receiverUid;
  private String remoteNickname;
  private String uid;
  private long filesize;
  private String message;
  private String absoluteFilename;
  private String filename;

  public PrivateChatfile() {}



  public String getReceiverUid() {
    return receiverUid;
  }



  public void setReceiverUid(String receiverUid) {
    this.receiverUid = receiverUid;
  }



  public String getUid() {
    return uid;
  }



  public void setUid(String uid) {
    this.uid = uid;
  }



  public long getFilesize() {
    return filesize;
  }



  public void setFilesize(long filesize) {
    this.filesize = filesize;
  }



  public String getMessage() {
    return message;
  }



  public void setMessage(String message) {
    this.message = message;
  }



  public String getAbsoluteFilename() {
    return absoluteFilename;
  }



  public void setAbsoluteFilename(String absoluteFilename) {
    this.absoluteFilename = absoluteFilename;
  }



  public String getFilename() {
    return filename;
  }



  public void setFilename(String filename) {
    this.filename = filename;
  }



  public String getRemoteNickname() {
    return remoteNickname;
  }



  public void setRemoteNickname(String nickname) {
    this.remoteNickname = nickname;
  }



  public Long getAnlage() {
    return anlage;
  }



  public void setAnlage(Long anlage) {
    this.anlage = anlage;
  }

}
