/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.environment;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import net.javacomm.facade.CommandLineException;
import net.javacomm.facade.Server;
import net.javacomm.server.ServerImpl;



/**
 * 
 * Ein Konsolenaufsatz für den Server.
 * 
 * 
 * 
 * @author llange
 *
 */
public class Application extends CommandLineImpl {

  private final static Logger log = LogManager.getLogger(Application.class);

  /**
   * Der Programmeinstieg.
   * 
   * @param args
   *             enthält keine Parameter
   */
  public static void main(String... args) {
    // log.info("args=" + args.length);
    Application cli = new Application(); // cli CommandLineInterface
    try {
      if (cli.evaluate(args)) {
        Server server = ServerImpl.getInstance();
        server.execute();
      }
      else {
        log.error("Der Server wurde fehlerhaft gestartet.");
        log.info("richtiger Aufruf:");
        log.info("                 java -jar server-1.00.jar");
      }
    }
    catch (CommandLineException e) {
      log.fatal(e.getMessage(), e.getCause());
    }
  }

}
