/**
 * The MIT License
 * Copyright © 2022 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package net.javacomm.schulz;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

@SuppressWarnings("serial")
public class JOnlyNumberTextField extends JTextField {

	private KeyAction actionKey = new KeyAction();
	private char[] numbers = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };

	public JOnlyNumberTextField() {
		this.addKeyListener(actionKey);
	}

	private void checkText() {
		String testText = this.getText();
		char[] signsInText = testText.toCharArray();
		String solution ="";

		for (int i = 0; i < signsInText.length; i++) {
			for (int j = 0; j < numbers.length; j++) {
				if(signsInText[i] == numbers[j]) {
					solution += signsInText[i];
					break;
				}
			}
		}
		
		this.setText(solution);
	}

	class KeyAction extends KeyAdapter {

		@Override
		public void keyReleased(KeyEvent event) {
			checkText();
		}
	}
}
