/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*****************************************************************************/
/*                                                                           */
/* Main Class  : JOptionFrame                                                */
/* Owner       : Thorsten Schulz                                             */
/* License     : All rights reserved                                         */
/* Createtd    : 09.08.2006 by Thorsten Schulz, TSchulz@javacomm.net         */
/* Last Update : 27.07.2020 by Thorsten Schulz                               */
/*                                                                           */
/*****************************************************************************/


public class JOptionFrame extends JFrame implements ActionListener{

  /**
    *
    */
  private static final long serialVersionUID = 7802129474087430650L;
  private PropertyChangeSupport change = new PropertyChangeSupport(this);
  private GridBagLayout gridbag        = new GridBagLayout();
  private GridBagConstraints c         = new GridBagConstraints();
  private int screenHeight, screenWidth;
  private Toolkit toolkit;
  private Dimension dim;
  private WindowAction actionWindow    = new WindowAction();
  private JPanel mainPanel             = new JPanel();
  private JButton[] buttonOption;
  private JLabel labMessage;


  public JOptionFrame(
                      //ParameterListe
                      //==============
                      Dimension sizeOfFrame,
                      int numberOfOptions,
                      String[] optionText,
                      String frameMessage,
                      String frameTitle,
                      Color colorFrame,
                      Color colorMessage,
                      Color colorButton,
                      Color colorButtonText){



    buttonOption = new JButton[numberOfOptions];

    for(int y=0;y<numberOfOptions;y++){
      buttonOption[y] = new JButton();
      buttonOption[y].setText(optionText[y]);
      buttonOption[y].setForeground(colorButtonText);
      buttonOption[y].setBackground(colorButton);
      buttonOption[y].addActionListener(this);
    }

    labMessage = new JLabel();
    labMessage.setText(frameMessage);
    labMessage.setForeground(colorMessage);

    mainPanel.setLayout(gridbag);

    c.insets = new Insets(5,5,5,5);
    c.fill = GridBagConstraints.HORIZONTAL;
    c.gridwidth = GridBagConstraints.REMAINDER;
    gridbag.setConstraints(labMessage, c);
    mainPanel.add(labMessage);

    c.gridwidth = 1;

    for(int x=0;x<numberOfOptions;x++){
      gridbag.setConstraints(buttonOption[x], c);
      mainPanel.add(buttonOption[x]);
    }

    mainPanel.setBackground(colorFrame);


    //Frame Parameter
    setContentPane(mainPanel);
    setTitle(frameTitle);
    setResizable(false);
    setDefaultCloseOperation (JFrame.DO_NOTHING_ON_CLOSE);
    addWindowListener(actionWindow);
    toolkit = Toolkit.getDefaultToolkit();

    dim = toolkit.getScreenSize();
    screenWidth  = dim.width;  //Breite der Systemeinstellungen
    screenHeight = dim.height; //H�he der Systemeinstellungen

    // Windows Umgebung
    //try  {
    //  UIManager.setLookAndFeel ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    //  SwingUtilities.updateComponentTreeUI (this);
    //}
    //catch (Exception e)  {
    //  System.out.println (e);
    //}

    /* setBounds(x-Koordinate der linken oberen Ecke des Frames, y-Koordinate der
     * linken oberen Ecke des Frames, Breite des Frames, Höhe des Frames) */
    setBounds((screenWidth-sizeOfFrame.width)>>1,
    (screenHeight-sizeOfFrame.height)>>1,
    sizeOfFrame.width,
    sizeOfFrame.height);
    setVisible(true);
  }

  @Override
  public void actionPerformed(ActionEvent event){
    Object obj = event.getSource();
    for(int i=0;i<buttonOption.length;i++){
      if(obj.equals(buttonOption[i])){
        change.firePropertyChange(event.getActionCommand(),
                                  Integer.valueOf(-10),
                                  Integer.valueOf(i));
        break;
      }
    }
    setVisible(false);
    dispose();
  }




  @Override
  public synchronized void addPropertyChangeListener(PropertyChangeListener l){

	    if(change == null){
	    	return;
	    }

	    change.addPropertyChangeListener(l);
	    return;
	}

	@Override
  public synchronized void removePropertyChangeListener(PropertyChangeListener l){

	    if(change == null){
	        return;
	    }

	    change.removePropertyChangeListener(l);
	    return;
	}


  /******************************************************************/
  /*                                                                */
  /*                     Class WindowAction                         */
  /*                                                                */
  /******************************************************************/

  class WindowAction extends WindowAdapter{

    @Override
    public void windowClosing(WindowEvent event){
    }
  }
}
