/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JRadioButton;



/*****************************************************************************/
/*                                                                           */
/* Class       : JPolygonButton                                              */
/* Owner       : Thorsten Schulz                                             */
/* License     : All rights reserved                                         */
/* Createtd    : 30.03.2004 by Thorsten Schulz, TSchulz@javacomm.net         */
/* Last Update : 17.04.2020 by Thorsten Schulz                               */
/*                                                                           */
/*****************************************************************************/

public class JPolygonButton extends JRadioButton {

  /**
    * 
    */
  private static final long serialVersionUID = 4057792875016603159L;
  private MouseAction actionMouse = new MouseAction();
  private Polygon polygon;
  private int[] x, y;
  private int n;
  private Color color;

  public JPolygonButton(int[] xPoints, int[] yPoints, int nPoints) {
    addMouseListener(actionMouse);

    color = new Color(0, 0, 0);

    x = xPoints;
    y = yPoints;
    n = nPoints;

    polygon = new Polygon(x, y, n);
  }



  @Override
  public Dimension getPreferredSize() {
    return (new Dimension(Functions.getMaxOfIntArray(x), Functions.getMaxOfIntArray(y)));
  }



  @Override
  public void paintComponent(Graphics g) {

    super.paintComponent(g);

    Graphics2D g2 = (Graphics2D) g;

    g2.setColor(new Color(192, 192, 192));
    g2.fillRect(0, 0, Functions.getMaxOfIntArray(x), Functions.getMaxOfIntArray(y));
    // ---------------------------------
    g2.setColor(color);
    g2.fillPolygon(polygon);
    return;
  }

  /*****************************************************************************/
  /*                                                                           */
  /* InnerClass : MouseAction */
  /* Owner : Thorsten Schulz */
  /* License : All rights reserved */
  /* Createtd : 30.03.2004 by Thorsten Schulz, TSchulz@javacomm.net */
  /* Last Update : 30.03.2004 by Thorsten Schulz */
  /*                                                                           */
  /*****************************************************************************/

  public class MouseAction extends MouseAdapter {
    @Override
    public void mouseEntered(MouseEvent event) {
      setCursor(new Cursor(Cursor.HAND_CURSOR));
    }



    @Override
    public void mouseExited(MouseEvent event) {
      setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
    }



    @Override
    public void mousePressed(MouseEvent event) {
      color = Color.pink;
    }



    @Override
    public void mouseReleased(MouseEvent event) {
      color = Color.black;
    }
  }
}