/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package net.javacomm.schulz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

/***************************************************************************/
/*                                                                         */
/* Class       : JRenderer                                                 */
/* Owner       : Thorsten Schulz                                           */
/* License     : All rights reserved                                       */
/* Createtd    : 19.02.2007 by Thorsten Schulz, TSchulz@javacomm.net       */
/* Last Update : 17.04.2020 by Thorsten Schulz                             */
/*                                                                         */
/***************************************************************************/



@SuppressWarnings("rawtypes")
public class JRenderer extends JLabel implements ListCellRenderer {

  /**
    * 
    */
  private static final long serialVersionUID = 1601784749749276935L;
  private Color bg, fg;
  private Font font;


  public JRenderer(Color bg, Color fg, boolean opaque, Font font) {
    setHorizontalAlignment(JLabel.LEFT);
    setVerticalAlignment(JLabel.CENTER);
    setOpaque(opaque);
    this.bg = bg;
    this.fg = fg;
    this.font = font;
  }

  @Override
  public Component getListCellRendererComponent(
                   JList list,
                   Object value,
                   int index,
                   boolean isSelected,
                   boolean cellHasFocus)
                {
    if (isSelected) {
      setBackground(fg);
      setForeground(bg);
    }
    else {
      setBackground(bg);
      setForeground(fg);
    }
    try {
      setText (value.toString ());
      setFont (font);
    }
    catch (NullPointerException e){}  // leerString
    return this;
  }
}
