/**
 * The MIT License
 * Copyright © 2020 Thorsten Schulz <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JMenu;

/******************************************************************/
/*                                                                */
/*                    Class JColorMenu                            */
/*                                                                */
/******************************************************************/

public class JColorMenu extends JMenu {

  /**
	* 
    */
  private static final long serialVersionUID = -3399268728726415332L;
  private Color highlightBarBack, highlightBarFore;
  public JColorMenu (String item) {
    super (item);
    setHighlightEqualsMenuColors();
  }

  public void setHighlightbarColors(Color background, Color foreground){
    highlightBarBack = background;
    highlightBarFore = foreground;
    return;
  }

  public void setHighlightEqualsMenuColors(){
    highlightBarBack = super.getBackground();
    highlightBarFore = super.getForeground();
    return;
  }

  @Override
  public void paintComponent (Graphics g)  {

    if (!isSelected ()) {
      super.paintComponent (g);
      return;
    }

    g.setColor (highlightBarFore);
    g.fillRect (0, 0, getSize().width, getSize().height);
    g.setColor (highlightBarBack);
    g.drawString (super.getText (), 10, 14);
  }
}