/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.gui.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;



/**
 * Jede Swing Application hat einen JFrame als oberste GUI Komponente.
 * 
 * @author llange
 *
 */
public abstract class JApplication extends JFrame implements Runnable {

  private static final long serialVersionUID = 1460804864360571578L;
  protected static Dimension PREFRRED_DIMENSION = new Dimension(990, 792);
  protected static Dimension MINIMUM_DIMENSION = new Dimension(960, 792);
  protected WindowAction windowAction = new WindowAction();
  protected Toolkit toolkit = Toolkit.getDefaultToolkit();

  protected class WindowAction extends WindowAdapter {
    /**
     * Wird aufgerufen, wenn JFrame geschlossen wird. In
     * {@link #windowClosing(WindowEvent)} können Aufräumarbeiten vorgenommen
     * werden.
     */
    @Override
    public void windowClosing(WindowEvent event) {
      JApplication.this.dispose();
    }
  }

  public JApplication() {
    getRootPane().setDoubleBuffered(true);
  }



  /**
   * {@code run()} wird aus main() über SwingUtilities aufgerufen.
   * 
   */
  @Override
  public void run() {
    setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    addWindowListener(windowAction);
    setPreferredSize(PREFRRED_DIMENSION);
    Dimension screensize = toolkit.getScreenSize();
    int midx = (screensize.width - getPreferredSize().width) / 2;
    int midy = (screensize.height - getPreferredSize().height) / 2;
    this.setBounds(midx, midy, getPreferredSize().width, getPreferredSize().height);
    pack();
    setVisible(true);
    createBufferStrategy(2);
  }

}
