/*
 * Copyright © 2020, Luis Andrés Lange <https://javacomm.net>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.nexuswob.gui.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;



public class NimbusCellRenderer<T> extends JLabel implements ListCellRenderer<T> {
  private static final long serialVersionUID = -7778073244099883503L;

  public NimbusCellRenderer() {
    setOpaque(true);
  }



  @Override
  public Component getListCellRendererComponent(JList<? extends T> list, T value, int index,
      boolean isSelected, boolean cellHasFocus) {

    if (value != null) setText(value.toString());
    if (isSelected) {
      setBackground(UIManager.getColor("nimbusSelectionBackground"));
      setForeground(UIManager.getColor("nimbusSelectedText"));
    }
    else {
      setBackground(Color.WHITE);
      setForeground(UIManager.getColor("textForeground"));
    }

    setBorder(new EmptyBorder(3, 3, 3, 3));

    return this;

  }

}
