/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


/*****************************************************************************/
/*                                                                           */
/*                                Class ImageBlaster                         */
/*                                                                           */
/*****************************************************************************/



public class ImageBlaster extends JPanel {

	private static final long serialVersionUID = -7290538816587707725L;
  private final Logger log = LogManager.getLogger(ImageBlaster.class);
	private Image image;
  private MediaTracker tracker;
  private boolean halt = false;
  private Dimension dim;


  public ImageBlaster (Image image)  {
    super (true);
    this.image = image;
    tracker = new MediaTracker (this);
    tracker.addImage (image, 0);
    try  {
      tracker.waitForID (0);
    }
    catch (InterruptedException e)  {
      e = new InterruptedException ("Animate.Animate (Image)");
      log.info(e.getMessage());
    }
    dim = new Dimension (image.getWidth (this), image.getHeight (this));
  }


  @Override
  public Dimension getPreferredSize ()  {
    return (dim);
  }


  public void setImage (Image image)  {
    this.image = image;
    setSize (image.getWidth (this), image.getHeight (this));
  }



  @Override
  public synchronized void repaint ()  {
    super.repaint ();
  }



  @Override
  public synchronized void paintComponent (Graphics g)  {
    if (!halt) {
      update (g);
    }
  }



  @Override
  public void update (Graphics g)  {
    g.drawImage (image, 0, 0, this);

  }



  public void halt ()  {
    halt = true;
  }



  public void restart ()  {
    halt = false;
  }


}
