/**
 * The MIT License
 * Copyright © 2020 Luis Andrés Lange <http://javacomm.net>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.nexuswob.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;



public class Singleton {

  final Logger log = LogManager.getLogger(Singleton.class);
  private static Singleton instance;
  int c;

  static {
    instance = new Singleton();
  }

  private Singleton() {}



  public static Singleton getInstance() {
    return instance;
  }



  /**
   * Addiere 2 Zahlen.
   * 
   * @param a
   *          beliebige Zahl
   * @param b
   *          beliebige Zahl
   * 
   * @return Ergebnis von a+b
   * @throws InterruptedException
   */
  public int plus(int a, int b) throws InterruptedException {
    // simuliert ein do Something
    Thread.sleep(2000);
    c = a + b;
    return c;
//    synchronized (instance) {
//      c = a + b;
//      return c;
//    }
  }



  public synchronized int plusAtomic(int a, int b) throws InterruptedException {
    // simuliert ein do Something
    Thread.sleep(2000);
    c = a + b;
    return c;
  }

}
