/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Objects;



public class CONFERENCE extends MESSAGE {

  public final static String KONFERENZNAME = "KONFERENZNAME";
  public final static String ORGANISATOR_UID = "ORGANISATOR_UID";
  public final static String USERID = "USERID";
  public final static String SESSION = "SESSION";
  public final static String OFFHOOK = "OFFHOOK";
  public final static String KONFERENZRAUMUSER = "KONFERENZRAUMUSER";

  private String konferenzname;
  private String organisatorUid;
  private String userid;
  private String session;
  private Boolean offhook;
  private KonferenzraumUser[] konferenzraumUser;

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    CONFERENCE other = (CONFERENCE) obj;
    return Objects.equals(konferenzname, other.konferenzname)
        && Arrays.equals(konferenzraumUser, other.konferenzraumUser)
        && Objects.equals(organisatorUid, other.organisatorUid);
  }



  public String getKonferenzname() {
    return konferenzname;
  }



  public KonferenzraumUser[] getKonferenzraumUser() {
    return konferenzraumUser;
  }



  public String getOrganisatorUid() {
    return organisatorUid;
  }



  public String getSession() {
    return session;
  }



  /**
   * Wer war der Absender dieser Botschaft?
   * 
   * @return dieser Anwender
   */
  public String getUserid() {
    return userid;
  }



  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + Arrays.hashCode(konferenzraumUser);
    result = prime * result + Objects.hash(konferenzname, organisatorUid);
    return result;
  }



  /**
   * Den Telefonförer auflegen oder abnehmen.
   * 
   * @return {@code true}, Hörer abnehmen; {@code false} Hörer aufgelegt
   */
  public Boolean isOffhook() {
    return offhook;
  }



  public void setKonferenzname(String konferenzname) {
    this.konferenzname = konferenzname;
  }



  public void setKonferenzraumUser(KonferenzraumUser[] konferenzraumUser) {
    this.konferenzraumUser = konferenzraumUser;
  }



  public void setOffhook(Boolean offhook) {
    this.offhook = offhook;
  }



  public void setOrganisatorUid(String organisatorUid) {
    this.organisatorUid = organisatorUid;
  }



  public void setSession(String session) {
    this.session = session;
  }



  /**
   * Dieser Anwender sendet die Botschaft {@code CONFERENCE}.
   * 
   * @param userid
   *               dieser Anwender
   */
  public void setUserid(String userid) {
    this.userid = userid;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    Gson gson = builder.registerTypeAdapter(CONFERENCE.class, new ConferenceSerializer())
        .registerTypeAdapter(KonferenzraumUser.class, new KonferenzraumUserSerializer()).create();
    return gson.toJson(this);
  }
}
