/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;



public class CONFERENCEMUTE extends MESSAGE {

  public final static String KONFERENZRAUM = "KONFERENZRAUM";
  public final static String ORGANISATOR = "ORGANISATOR";
  public final static String USERID = "USERID";
  public final static String RECEIVER_SESSIONS = "RECEIVER_SESSIONS";
  public final static String MUTE = "MUTE";

  private String konferenzraum;
  private String organisator; // ist eine userid
  private String userid; // der Absender
  private String[] receiverSessions;
  private Boolean mute; // true=mikro aus

  public CONFERENCEMUTE() {}



  public String getKonferenzraum() {
    return konferenzraum;
  }



  public String getOrganisator() {
    return organisator;
  }



  public String[] getReceiverSessions() {
    return receiverSessions;
  }



  public String getUserid() {
    return userid;
  }



  public Boolean isMute() {
    return mute;
  }



  /**
   * An diesen Konferenzraum wird gesendet.
   * 
   * @param konferenzraum
   *                      dieser Konferenzraum
   */
  public void setKonferenzraum(String konferenzraum) {
    this.konferenzraum = konferenzraum;
  }



  /**
   * Das Mikrofon wurde eingeschaltet oder ausgeschaltet.
   * 
   * @param mute
   *             {@code true}, stummgeschaltet
   */
  public void setMute(Boolean mute) {
    this.mute = mute;
  }



  /**
   * Der Konferenzraum wurde von dieser Person angelegt.
   * 
   * @param organisator
   *                    dieser EInrichter
   */
  public void setOrganisator(String organisator) {
    this.organisator = organisator;
  }



  /**
   * An diese Anwender wird gesendet.
   * 
   * @param receiverSessions
   *                         alle Empfänger
   */
  public void setReceiverSessions(String[] receiverSessions) {
    this.receiverSessions = receiverSessions;
  }



  /**
   * Dieser Anwender änderte seine Mikrofoneinstellung.
   * 
   * @param userid
   *               dieser Anwender
   */
  public void setUserid(String userid) {
    this.userid = userid;
  }



  @Override
  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }
}
