/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;



public class DIAL extends MESSAGE {

  public final static String CALLER_NICKNAME = "CALLER_NICKNAME";
  public final static String RECEIVER_IP = "RECEIVER_IP";
  public final static String RECEIVER_PORT = "RECEIVER_PORT";
  public final static String CALLER_USERID = "CALLER_USERID";
  public final static String CALLER_VOICE = "CALLER_VOICE";
  public final static String CALLER_SESSION = "CALLER_SESSION";
  public final static String RECEIVER_NICKNAME = "RECEIVER_NICKNAME";
  public final static String RECEIVER_USERID = "RECEIVER_USERID";
  public final static String RECEIVER_SESSION = "RECEIVER_SESSION";

  private String callerVoice; // Mandotory
  private String callerUserid; // Mandotory
  private String callerNickname; // Mandotory
  private String callerSession; // optional RESPONSE f�r TCP
  private String receiverIp; // Mandotory
  private Integer receiverPort; // Mandotory
  private String receiverSession; // die SessionID wird für TCP benötigt; das Attribut ist optional für
                                  // RESPONSE;
  // session ist die SessionId vom Empfänger

  public String getReceiverIp() {
    return receiverIp;
  }



  public void setReceiverIp(String receiverIp) {
    this.receiverIp = receiverIp;
  }



  public Integer getReceiverPort() {
    return receiverPort;
  }



  public void setReceiverPort(Integer receiverPort) {
    this.receiverPort = receiverPort;
  }

  private String receiverNickname; // Mandotory
  private String receiverUserid; // Optional

  public String getCallerVoice() {
    return callerVoice;
  }



  public void setCallerVoice(String callerVoice) {
    this.callerVoice = callerVoice;
  }



  public String getCallerUserid() {
    return callerUserid;
  }



  public void setCallerUserid(String callerUserid) {
    this.callerUserid = callerUserid;
  }



  public String getCallerNickname() {
    return callerNickname;
  }



  public void setCallerNickname(String callerNickname) {
    this.callerNickname = callerNickname;
  }



  public String getReceiverNickname() {
    return receiverNickname;
  }



  public void setReceiverNickname(String receiverNickname) {
    this.receiverNickname = receiverNickname;
  }



  public String getReceiverUserid() {
    return receiverUserid;
  }



  public void setReceiverUserid(String receiverUserid) {
    this.receiverUserid = receiverUserid;
  }



  public String getReceiverSession() {
    return receiverSession;
  }



  public void setReceiverSession(String session) {
    this.receiverSession = session;
  }



  public String getCallerSession() {
    return callerSession;
  }



  public void setCallerSession(String callerSession) {
    this.callerSession = callerSession;
  }



  @Override
  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }

}
