/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;



public class HistoryMessageSerializer implements JsonSerializer<HISTORYMESSAGE> {

  @Override
  public JsonElement serialize(HISTORYMESSAGE src, Type typeOfSrc, JsonSerializationContext context) {

    JsonObject jsonObject = new JsonObject();
    JsonObject dataset = new JsonObject();
    JsonArray record = new JsonArray();
    JsonObject objectAttachment = new JsonObject();

    dataset.add("ROOM", context.serialize(src.getRoom()));

    Attachment[] attachment = src.getAttachment();
    if (attachment != null && attachment.length > 0) {
      record.add(objectAttachment);

      for (Attachment attach : attachment) {
        String room = attach.getRoom();
        Long datetime = attach.getDatetime();
        String message = attach.getMessage();
        Long anhang = attach.getAttachment();
        String filename = attach.getFilename();
        Long filesize = attach.getFilesize();
        ChatUser chatuser = attach.getChatUser();

        objectAttachment.add("ROOM", context.serialize(room));
        objectAttachment.add("DATETIME", context.serialize(datetime));
        objectAttachment.add("MESSAGE", context.serialize(message));
        objectAttachment.add("ATTACHMENT", context.serialize(anhang));
        objectAttachment.add("FILENAME", context.serialize(filename));
        objectAttachment.add("FILESIZE", context.serialize(filesize));
        objectAttachment.add("CHATUSER", context.serialize(chatuser));
      }
    }

    dataset.add("RECORD", context.serialize(record));
    jsonObject.add("HEADER", context.serialize(src.getHeader()));
    jsonObject.add("COMMAND", context.serialize(src.getCommand()));
    jsonObject.add("DATASET", context.serialize(dataset));
    return jsonObject;
  }

}
