/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



public class ONHOOK extends MESSAGE {

  public final static String RECEIVER_USERID = "RECEIVER_USERID";
  public final static String CALLER_USERID = "CALLER_USERID";
  public final static String TO = "TO";
  public final static String SIGNAL = "SIGNAL";

  private String receiverUserid;
  private String callerUserid;
  private Boolean to;
  private boolean signal;

  /**
   * Wer hat aufgelegt?
   * 
   * @return {@code true}, der Caller hat aufgelegt
   */
  public Boolean isTo() {
    return to;
  }



  /**
   * Hat der Caller oder der Receiver aufgelegt?
   * 
   * @param to
   *           {@code true}, der Caller hat aufgelegt, {@code false} der Receiver
   *           hat aufgelegt
   */
  public void setTo(Boolean to) {
    this.to = to;
  }



  public String getReceiverUserid() {
    return receiverUserid;
  }



  /**
   * Der Empfänger.
   * 
   * @param selfUserid
   *                   dieser Anwender
   */
  public void setReceiverUserid(String selfUserid) {
    this.receiverUserid = selfUserid;
  }



  public String getCallerUserid() {
    return callerUserid;
  }



  /**
   * Der Anrufer.
   * 
   * @param callerUserid
   *                     dieser Anwender
   */
  public void setCallerUserid(String callerUserid) {
    this.callerUserid = callerUserid;
  }



  public boolean isSignal() {
    return signal;
  }



  /**
   * Busy tone einschalten oder aussschalten
   * 
   * @param signal
   *               {@code true}, busy tone soll abgespielt werden
   */
  public void setSignal(boolean signal) {
    this.signal = signal;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeHierarchyAdapter(ONHOOK.class, new OnhookSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
