/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class SCREENCAST extends MESSAGE {

  public final static String CALLER_USERID = "CALLER_USERID";
  public final static String CALLER_NICKNAME = "CALLER_NICKNAME";
  public final static String CALLER_ONHOOK = "CALLER_ONHOOK";
  public final static String CALLER_IP = "CALLER_IP";
  public final static String CALLER_PORT = "CALLER_PORT";
  public final static String RECEIVER_USERID = "RECEIVER_USERID";
  public final static String RECEIVER_NICKNAME = "RECEIVER_NICKNAME";
  public final static String RECEIVER_ONHOOK = "RECEIVER_ONHOOK";

  private String callerUserid;
  private String callerNickname;
  private String callerIp;
  private Integer callerPort;
  private String receiverNickname;
  private String receiverUserid;


  public String getCallerIp() {
    return callerIp;
  }



  public void setCallerIp(String callerIp) {
    this.callerIp = callerIp;
  }



  public Integer getCallerPort() {
    return callerPort;
  }



  public void setCallerPort(Integer callerPort) {
    this.callerPort = callerPort;
  }



  public String getCallerUserid() {
    return callerUserid;
  }



  public void setCallerUserid(String callerUserid) {
    this.callerUserid = callerUserid;
  }



  public String getCallerNickname() {
    return callerNickname;
  }



  public void setCallerNickname(String callerNickname) {
    this.callerNickname = callerNickname;
  }



  public String getReceiverNickname() {
    return receiverNickname;
  }



  public void setReceiverNickname(String receiverNickname) {
    this.receiverNickname = receiverNickname;
  }



  public String getReceiverUserid() {
    return receiverUserid;
  }



  public void setReceiverUserid(String receiverUserid) {
    this.receiverUserid = receiverUserid;
  }




}
