/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class SEARCHFILES extends MESSAGE {

  public final static String USERID = "USERID";
  public final static String SEARCHFILES = "SEARCHFILES";
  public final static String PATTERN = "FILE";
  public final static String SEARCHFILE = "SEARCHFILE";
  public final static String START = "START";

  private String userid;
  private String[] patterns;
  private Searchfile[] searchfile;
  private boolean start;


  public void setUserid(String value) {
  	userid = value;
  }
  
      
  public void setPatterns(String values[]) {
  	patterns = values;
  }
  
  
  public void setSearchfiles(Searchfile[] value) {
  	searchfile = value;
  }

  
  public void setStarted(boolean value) {
  	start = value;
  }

  
  public String getUserid() {
  	return userid;
  }
  
  
  public String[] getPatterns() {
  	return patterns;
  }
  
  
  public Searchfile[] getSearchfiles() {
  	return searchfile;
  }

  
  public boolean hasStarted() {
  	return start;
  }

  

  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(SEARCHFILES.class, new SearchFilesSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }

}
