/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.javacomm.multilingual.schema.KEY;



public class SigninDeserializer implements JsonDeserializer<SIGNIN> {

  @Override
  public SIGNIN deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {

    JsonObject jsonobject = json.getAsJsonObject();
    HEADER header = HEADER.toHeader(jsonobject.getAsJsonPrimitive(Protocol.HEADER).getAsString());
    JsonObject dataset = jsonobject.getAsJsonObject(Protocol.DATASET);

    String email = null;
    try {
      email = dataset.get(SIGNIN.EMAIL).getAsString();
    }
    catch (NullPointerException e) {}
    String password = null;
    try {
      password = dataset.get(SIGNIN.PASSWORD).getAsString();
    }
    catch (NullPointerException e) {}
    String userid = null;
    try {
      userid = dataset.get(SIGNIN.USERID).getAsString();
    }
    catch (NullPointerException e) {}
    String nickname = null;
    try {
      nickname = dataset.get(SIGNIN.NICKNAME).getAsString();
    }
    catch (NullPointerException e) {}
    Integer fgcolor = null;
    try {
      fgcolor = dataset.get(SIGNIN.FOREGROUND_COLOR).getAsInt();
    }
    catch (NullPointerException e) {}
    Integer bgcolor = null;
    try {
      bgcolor = dataset.get(SIGNIN.BACKGROUND_COLOR).getAsInt();
    }
    catch (NullPointerException e) {}
    KEY multilingualkey = null;
    try {
      multilingualkey = KEY.fromValue(dataset.getAsJsonPrimitive(SIGNIN.MULTILINGUALKEY).getAsString());
    }
    catch (NullPointerException e) {}
    String text = null;
    try {
      text = dataset.get(SIGNIN.TEXT).getAsString();
    }
    catch (NullPointerException e) {}
    Integer errorcode = null;
    try {
      errorcode = dataset.get(SIGNIN.ERRORCODE).getAsInt();
    }
    catch (NullPointerException e) {}
    String errormessage = null;
    try {
      errormessage = dataset.get(SIGNIN.ERRORMESSAGE).getAsString();
    }
    catch (NullPointerException e) {}
    String neuesPassword = null;
    try {
      neuesPassword = dataset.get(SIGNIN.NEUES_PASSWORD).getAsString();
    }
    catch (NullPointerException e) {}
    String confirmationKey = null;
    try {
      confirmationKey = dataset.get(SIGNIN.CONFIRMATION_KEY).getAsString();
    }
    catch (NullPointerException e) {}

    SIGNIN signin = new SIGNIN();
    signin.setHeader(header);
    signin.setCommand(Command.SIGNIN);
    signin.setDataset(Protocol.DATASET);
    signin.setEmail(email);
    signin.setPassword(password);
    signin.setUserid(userid);
    signin.setNickname(nickname);
    signin.setForegroundColor(fgcolor);
    signin.setBackgroundColor(bgcolor);
    signin.setMultilingualkey(multilingualkey);
    signin.setText(text);
    signin.setErrorCode(errorcode);
    signin.setErrorMessage(errormessage);
    signin.setNeuesPassword(neuesPassword);
    signin.setConfirmationKey(confirmationKey);

    return signin;

  }

}
