/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;



public class SigninSerializer implements JsonSerializer<SIGNIN> {

  @Override
  public JsonElement serialize(SIGNIN src, Type typeOfSrc, JsonSerializationContext context) {

    JsonObject jsonObject = new JsonObject();

    JsonObject dataset = new JsonObject();
    dataset.add(SIGNIN.EMAIL, context.serialize(src.getEmail()));
    dataset.add(SIGNIN.USERID, context.serialize(src.getUserid()));
    dataset.add(SIGNIN.NEUES_PASSWORD, context.serialize(src.getNeuesPassword()));
    dataset.add(SIGNIN.CONFIRMATION_KEY, context.serialize(src.getConfirmationKey()));
    dataset.add(SIGNIN.NICKNAME, context.serialize(src.getNickname()));
    dataset.add(SIGNIN.PASSWORD, context.serialize(src.getPassword()));
    dataset.add(SIGNIN.FOREGROUND_COLOR, context.serialize(src.getForegroundColor()));
    dataset.add(SIGNIN.BACKGROUND_COLOR, context.serialize(src.getBackgroundColor()));
    dataset.add(SIGNIN.BACKGROUND_COLOR, context.serialize(src.getBackgroundColor()));
    dataset.add(SIGNIN.ERRORCODE, context.serialize(src.getErrorCode()));
    dataset.add(SIGNIN.ERRORMESSAGE, context.serialize(src.getErrorMessage()));
    dataset.add(SIGNIN.TEXT, context.serialize(src.getText()));
    if (src.getMultilingualkey() != null)
      dataset.add(SIGNIN.MULTILINGUALKEY, context.serialize(src.getMultilingualkey().value()));

    jsonObject.add("HEADER", context.serialize(src.getHeader()));
    jsonObject.add("COMMAND", context.serialize(src.getCommand()));
    jsonObject.add("DATASET", context.serialize(dataset));

    return jsonObject;

  }

}
