/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;



/**
 * Das Token enthält die Anmeldeinformationen.
 */
public class Token {

  public final static String EMAIL = "EMAIL";
  public final static String USERID = "USERID";
  public final static String PASSWORD = "PASSWORD";
  public final static String AES = "AES";
  public final static String ONETIME = "ONETIME";

  private String eMail;
  private String userid;
  private String password;
  private String aes;
  private String onetime;

  public Token() {}



  public static Token toToken(String deserialize) {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(Token.class, new TokenDeserializer());
    Gson gson = builder.create();
    return gson.fromJson(deserialize, Token.class);

  }



  /**
   * Der Schlüssel ist Base64 codiert.
   * 
   * @return dieser AES Schlüssel
   */
  public final String getAES() {
    return aes;
  }



  public final String getEMail() {
    return eMail;
  }



  public String getOnetime() {
    return onetime;
  }



  public final String getPassword() {
    return password;
  }



  public String getUserid() {
    return userid;
  }



  /**
   * AES: <b>zwingend</b>
   * 
   * @param aes
   *            dieser AES Schlüssel
   */
  public final void setAES(String aes) {
    this.aes = aes;
  }



  /**
   * Mail: <b>optional</b>
   * 
   * 
   * @param eMail
   *              diese Mailadresse
   */
  public final void setEMail(String eMail) {
    this.eMail = eMail;
  }



  public void setOnetime(String onetime) {
    this.onetime = onetime;
  }



  /**
   * Passwort: <b>zwingend</b>
   * 
   * @param password
   *                 dieses Passwort
   */
  public final void setPassword(String password) {
    this.password = password;
  }



  /**
   * Userid: <b>optional</b>
   * 
   * @param userid
   *               diese Userid
   */
  public void setUserid(String userid) {
    this.userid = userid;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    Gson gson = builder.registerTypeAdapter(Token.class, new TokenSerializer()).create();
    return gson.toJson(this);
  }

}
