/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

public class UPLOADFILES extends MESSAGE {

	
  public final static String USERID = "USERID";
  public final static String IP = "IP";
  public final static String PORT = "PORT";
  public final static String UPLOADFILES = "UPLOADFILES";
  public final static String FILE = "FILE";
  public final static String START = "START";

	
  private String userid;
  private String ip;
  // start ist true, wenn der erste Block übertragen wird.
  private boolean start;
  private int port;
  private Uploadfile[] uploadfile;
  
  
  public Uploadfile[] getUploadfile() {
    return uploadfile;
  }


  public void setUploadfile(Uploadfile[] uploadfile) {
    this.uploadfile = uploadfile;
  }


  public void setUserid(String value) {
  	userid = value;
  }
  
  
  public void setIp(String value) {
  	ip = value;
  }
  
  
  public void setPort(int value) {
    port = value;
  }
  
  
  public void setStarted(boolean value) {
  	start = value;
  }
  
  
  public String getUserid() {
  	return userid;
  }
  
  
  public String getIp() {
  	return ip;
  }
  
  
  public int getPort() {
    return port;
  }
  
  
  
  public boolean hasStarted() {
  	return start;
  }
	
}
