/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;



public class UpdateuserSerializer implements JsonSerializer<UPDATEUSER> {

  public UpdateuserSerializer() {}



  @Override
  public JsonElement serialize(UPDATEUSER updateuser, Type type, JsonSerializationContext context) {
    JsonObject jsonObject = new JsonObject();
    JsonObject dataset = new JsonObject();

    dataset.add(UPDATEUSER.IDENTITY, context.serialize(updateuser.getIdentity()));
    dataset.add(UPDATEUSER.NICKNAME, context.serialize(updateuser.getNickname()));
    dataset.add(UPDATEUSER.FOREGROUND_COLOR, context.serialize(updateuser.getForegroundColor()));
    dataset.add(UPDATEUSER.BACKGROUND_COLOR, context.serialize(updateuser.getBackgroundColor()));
    dataset.add(UPDATEUSER.TEXT, context.serialize(updateuser.getText()));

    jsonObject.add("HEADER", context.serialize(updateuser.getHeader()));
    jsonObject.add("COMMAND", context.serialize(updateuser.getCommand()));
    jsonObject.add("DATASET", context.serialize(dataset));

    return jsonObject;
  }

}
