/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

public enum Starttype {

  MANUAL_DE(1, "von Hand aus starten"),
  MANUAL_EN(2, "start manually"),
  MANUAL_ES(3, "iniciar manualmente"),
  AUTOMATIC_DE(4, "automatisch nach jedem Programmstart"),
  AUTOMATIC_EN(5, "automatically after each program start"),
  AUTOMATIC_ES(6, "automáticamente después de cada inicio del programa");


  private int modus;
  private String beschreibung;

  private Starttype(int modus, String beschreibung) {
    this.modus = modus;
    this.beschreibung = beschreibung;
  }



  public int getModus() {
    return modus;
  }



  @Override
  public String toString() {
    return beschreibung;
  }



  public static Starttype toTransferStarttype(int modus) {
    for (Starttype tmp : Starttype.values()) {
      if (tmp.getModus() == modus) {
        return tmp;
      }
    }
    throw new IllegalArgumentException();
  }



  public static Starttype toTransferStarttype(String beschreibung) {
    for (Starttype tmp : Starttype.values()) {
      if (tmp.toString().equals(beschreibung)) {
        return tmp;
      }
    }
    throw new IllegalArgumentException();
  }
}
