/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

import com.google.gson.Gson;



/**
 * 
 * Ein Transferobjekt zwischen Server und Client.
 * 
 * 
 * @author llange
 *
 */
public class TransferConfig {

  private String domain;
  private boolean isPublic;
  private String mailSmtpUser;
  private String mailSmtpHost;
  private Integer mailSmtpPort;
  private int flipToForum = 150;
  private int hours;
  private int account;

  public String getDomain() {
    return domain;
  }



  public void setDomain(String domain) {
    this.domain = domain;
  }



  public boolean getIsPublic() {
    return isPublic;
  }



  public void setIsPublic(boolean isPublic) {
    this.isPublic = isPublic;
  }



  public String getMailSmtpUser() {
    return mailSmtpUser;
  }



  public void setMailSmtpUser(String mailSmtpUser) {
    this.mailSmtpUser = mailSmtpUser;
  }



  public String getMailSmtpHost() {
    return mailSmtpHost;
  }



  public void setMailSmtpHost(String mailSmtpHost) {
    this.mailSmtpHost = mailSmtpHost;
  }



  @Override
  public String toString() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }



  public Integer getMailSmtpPort() {
    return mailSmtpPort;
  }



  public void setMailSmtpPort(Integer mailSmtpPort) {
    this.mailSmtpPort = mailSmtpPort;
  }



  public int getFlipToForum() {
    return flipToForum;
  }



  public void setFlipToForum(int flipToForum) {
    this.flipToForum = flipToForum;
  }



  public int getHours() {
    return hours;
  }



  public void setHours(int hours) {
    this.hours = hours;
  }



  public int getAccount() {
    return account;
  }



  public void setAccount(int account) {
    this.account = account;
  }

}
