/**
 *  Copyright © 2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  Previously released under Apache License 2.0; now licensed under MPL 2.0.
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 *  In short:
 *  - This file may be used, modified, and distributed under MPL 2.0 only.
 *  - It may NOT be relicensed under GPL, LGPL, AGPL, or any other Secondary License.
 *
 *  Rationale:
 *  - Ensures that the code remains MPL-2.0.
 *  - Avoids legal conflicts with GPL-licensed libraries (e.g., VideoLAN).
 *  - Maximizes usability for commercial and security-critical applications.
 *
 */
package net.javacomm.transfer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.ZonedDateTime;



/**
 * Die Einträge aus der Maske JTelefonkonferenzFrame.
 *
 * @author lromero
 *
 */
public class TransferTelko {

  private String konferenzraum; // Konferenzname
  private String organisator; // Organisator
  private String beschreibung;
  private ZonedDateTime ablaufdatum;


  public String getKonferenzraum() {
    return konferenzraum;
  }



  public void setKonferenzraum(String telkoid) {
    this.konferenzraum = telkoid;
  }



  public String getOrganisator() {
    return organisator;
  }



  public void setOrganisator(String uid) {
    this.organisator = uid;
  }




  public String getBeschreibung() {
    return beschreibung;
  }



  public void setBeschreibung(String beschreibung) {
    this.beschreibung = beschreibung;
  }



  public ZonedDateTime getAblaufdatum() {
    return ablaufdatum;
  }



  public void setAblaufdatum(ZonedDateTime ablaufdatum) {
    this.ablaufdatum = ablaufdatum;
  }



  @Override
  public String toString() {
    GsonBuilder builder = new GsonBuilder();
    builder = builder.registerTypeAdapter(ZonedDateTime.class, new ZonedDateTimeSerializer());
    Gson gson = builder.create();
    return gson.toJson(this);
  }


}
