package net.javacomm.protocol;

import static org.junit.jupiter.api.Assertions.assertEquals;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Test;
import net.javacomm.protocol.crypto.Crypto;



public class TestTokenSerializer {

  private final static Logger log = LogManager.getLogger(TestTokenSerializer.class);

  public TestTokenSerializer() {}



  @Test
  public void serializeIdentity() {
    Token token = new Token();
    token.setAES("dkeowkd");
    token.setEMail("admin@javacomm.net");
    token.setPassword("12345678");
    token.setUserid("admin678");

//     "EMAIL":"admin@javacomm.net","USERID":"admin678","PASSWORD":"12345678","AES":"dkeowkd"

    StringBuilder builder = new StringBuilder().append(
        "{\"EMAIL\":\"admin@javacomm.net\",\"USERID\":\"admin678\",\"PASSWORD\":\"12345678\",\"AES\":\"dkeowkd\"}"
    );
    assertEquals(builder.toString(), token.toString());
    log.info(builder.toString());

    JsonParser.parseString(builder.toString());

  }



  @Test
  public void serializeString() {
    SecretKey secretkey = Crypto.createAES();
    String secretkey64 = Crypto.getBase64FromAES(secretkey);
    StringBuilder builder = new StringBuilder().append("\"{" + secretkey64 + "}\"");
    JsonParser.parseString(builder.toString());

//    log.info(builder.toString());

    Gson gson = new Gson();
    String json = gson.toJson(secretkey64);
    log.info("json=" + json);

    JsonParser.parseString(json);

  }



  @Test
  public void toUSRLOGIN() {

    USRLOGIN result = USRLOGIN.toUSRLOGIN(
        "{\"HEADER\":\"REQUEST\",\"COMMAND\":\"USRLOGIN\",\"DATASET\":{\"IP\":\"localhost\",\"AGENT\":\"SmartPhone\",\"IDENTITY\":\"6tpUji8mIr+FSQQL5Hi3kg\\u003d\\u003d\"}}"
    );

    log.info(result.getIdentity());

  }

}
