/**
 * This software is released as part of the Pumpernickel project.
 * 
 * All com.pump resources in the Pumpernickel project are distributed under the
 * MIT License:
 * https://github.com/mickleness/pumpernickel/raw/master/License.txt
 * 
 * More information about the Pumpernickel project is available here:
 * https://mickleness.github.io/pumpernickel/
 */
package com.pump.icon;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;

import javax.swing.Icon;

import com.pump.blog.ResourceSample;

/**
 * An icon of a magnifying glass.
 * <P>
 * This is based on what I saw in Firefox and Safari.
 * 
 * <!-- ======== START OF AUTOGENERATED SAMPLES ======== -->
 * <p>
 * <img src=
 * "https://github.com/mickleness/pumpernickel/raw/master/resources/samples/SearchIcon/sample.png"
 * alt="new&#160;com.pump.swing.resources.SearchIcon(&#160;12&#160;)"> <!--
 * ======== END OF AUTOGENERATED SAMPLES ======== -->
 */
@ResourceSample(sample = { "new com.pump.swing.resources.SearchIcon( 12 )" })
public class SearchIcon implements Icon {
	int size;

	/**
	 * Creates a new <code>SearchIcon</code>.
	 * 
	 * @param size
	 *            the dimensions of the square in which this icon will be
	 *            rendered. The icon data is vector and will scale to fit the
	 *            size you ask for.
	 */
	public SearchIcon(int size) {
		this.size = size;
	}

	public int getIconHeight() {
		return size;
	}

	public int getIconWidth() {
		return size;
	}

	public void paintIcon(Component c, Graphics g0, int x, int y) {
		Graphics2D g = (Graphics2D) g0;
		g = (Graphics2D) g.create();
		g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		g.translate(x, y);
		// this was designed around 12-pixel icons
		float scale = (size) / 12f;
		g.scale(scale, scale);
		g.setColor(new Color(0x656565));
		g.setStroke(new BasicStroke(2f));
		g.draw(new Ellipse2D.Float(0, 0, 8, 8));
		g.draw(new Line2D.Float(7, 7, 11.5f, 11.5f));
	}
}