/**
 * This software is released as part of the Pumpernickel project.
 * 
 * All com.pump resources in the Pumpernickel project are distributed under the
 * MIT License:
 * https://github.com/mickleness/pumpernickel/raw/master/License.txt
 * 
 * More information about the Pumpernickel project is available here:
 * https://mickleness.github.io/pumpernickel/
 */
package com.pump.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.Icon;

import com.pump.blog.ResourceSample;

/**
 * One of three icons used to toggle views in file browsers/dialogs.
 * 
 * <!-- ======== START OF AUTOGENERATED SAMPLES ======== -->
 * <p>
 * <img src=
 * "https://github.com/mickleness/pumpernickel/raw/master/resources/samples/TileIcon/sample.png"
 * alt="new&#160;com.pump.swing.resources.TileIcon(12,&#160;12)"> <!-- ========
 * END OF AUTOGENERATED SAMPLES ======== -->
 * 
 * @see ColumnIcon
 * @see ListIcon
 * @see StackIcon
 */
@ResourceSample(sample = { "new com.pump.swing.resources.TileIcon(12, 12)" })
public class TileIcon implements Icon {
	final int w, h;

	public TileIcon(int width, int height) {
		w = width;
		h = height;
	}

	public int getIconHeight() {
		return h;
	}

	public int getIconWidth() {
		return w;
	}

	public void paintIcon(Component c, Graphics g0, int x, int y) {
		Graphics2D g = (Graphics2D) g0.create();

		g.setColor(Color.darkGray);
		g.translate(x, y);
		int rows = (h + 2) / 6;
		int columns = (w + 2) / 6;
		int dy = h / 2 - ((rows * 6 - 2) / 2);
		int dx = w / 2 - ((columns * 6 - 2) / 2);
		g.translate(dx, dy);
		for (int row = 0; row < rows; row++) {
			for (int col = 0; col < columns; col++) {
				g.drawRect(col * 6, row * 6, 3, 3);
			}
		}
		g.dispose();
	}
}