/**
 * This software is released as part of the Pumpernickel project.
 * 
 * All com.pump resources in the Pumpernickel project are distributed under the
 * MIT License:
 * https://github.com/mickleness/pumpernickel/raw/master/License.txt
 * 
 * More information about the Pumpernickel project is available here:
 * https://mickleness.github.io/pumpernickel/
 */
package com.pump.icon;

import java.awt.Component;
import java.awt.Graphics;

import javax.swing.Icon;
import javax.swing.SwingConstants;

import com.pump.blog.ResourceSample;

/**
 * An icon that includes both an up triangle and a down triangle with a little
 * vertical padding in-between.
 * <p>
 * This is used to indicate choices above and below. For example a button that
 * triggers a popup menu might include this icon.
 *
 * 
 * <!-- ======== START OF AUTOGENERATED SAMPLES ======== -->
 * <p>
 * <img src=
 * "https://github.com/mickleness/pumpernickel/raw/master/resources/samples/UpDownIcon/sample.png"
 * alt="new&#160;com.pump.swing.resources.UpDownIcon(&#160;5,&#160;4,&#160;3)">
 * <!-- ======== END OF AUTOGENERATED SAMPLES ======== -->
 */
@ResourceSample(sample = { "new com.pump.swing.resources.UpDownIcon( 5, 4, 3)" })
public class UpDownIcon implements Icon {

	public final TriangleIcon downIcon, upIcon;
	public final int trianglePadding;

	public UpDownIcon(int triangleWidth, int triangleHeight, int trianglePadding) {
		downIcon = new TriangleIcon(SwingConstants.SOUTH, triangleWidth,
				triangleHeight);
		upIcon = new TriangleIcon(SwingConstants.NORTH, triangleWidth,
				triangleHeight);
		this.trianglePadding = trianglePadding;
	}

	public int getIconHeight() {
		return downIcon.getIconHeight() + upIcon.getIconHeight()
				+ trianglePadding;
	}

	public int getIconWidth() {
		return Math.max(downIcon.getIconWidth(), upIcon.getIconWidth());
	}

	public void paintIcon(Component c, Graphics g, int x, int y) {
		upIcon.paintIcon(c, g, x, y);
		downIcon.paintIcon(c, g, x, y + upIcon.getIconHeight()
				+ trianglePadding);
	}

}