/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

public enum Control {

  NULL(0),
  SELECTED(1),
  MESSAGE(2),
  HIT(3),
  REGISTRIEREN(4),
  NOTIFY(5),
  WEITER(6),
  INPUT_FOCUS(7),
  CHATTOOLTIP(8),
  ANLAGE(9),
  START(10),
  SEND(11),
  HISTORYMESSAGE(12),
  CANCEL(13),
  NEUES_PASSWORD(14),
  TOPICMEMBER(15),
  UPDATE_CHATUSER(16),
  CREATE(17),
  DELETE(18),
  CLOSE(19),
  ROOM(20),
  TOPIC(21),
  PRIVATECHAT(22),
  RESTRICTION(23),
  REQUEST(24),
  DELETEUPLOAD(25),
  UPLOADFILE(26),
  STOP(27),
  DOWNLOAD(28),
  DISCONNECT(29),
  TRANSMIT(30),
  SEARCH(31),
  EXIT_ON_CLOSE(32),
  SONG_FINISHED(33),
  VOLUME(34),
  MEDIAPLAYER_PAUSE(35),
  MEDIAPLAYER_START(36),
  MEDIAPLAYER_REWIND(37),
  CAPTURE(38),
  TELEFON_SPEICHERN(39),
  SHUFFLE_CONTINUE(40),
  SINGLE_QUIT(41),
  SHUFFLE_WINDOW_CLOSE(42),
  CONTINUE(43),
  REGISTER(44),
  CONFIRM(45),
  TELEFON_ABNEHMEN(46),
  TELEFON_AUFLEGEN(47),
  TELEFON_WAEHLEN(48),
  EMAIL_TEXT(49),
  UPDATE_ODX(50),
  MEDIAPLAYER_RESIZE(51),
  MEDIAPLAYER_FRAME_ACTIVATED(52),
  SAVE_AND_CLOSE(53),
  BREAKROOMS(54),
  VOLLBILDMODUS(55),
  PLAYERMODE(56),
  DVD_QUIT(57),
  SAVE(58),
  SAVE_BENUTZERANTRAEGE(59),
  SAVE_RAUMFILTER(60),
  TESTMAIL(61),
  TELEFON_VOLUME(62),
  STOP_SCREENSAVER(63),
  BUTTON_1(64),
  BUTTON_2(65),
  TEST(66),
  SAVE_PROGRAMMVERSIONEN(67),
  SAVE_NICKNAMES(68),
  IPTV_VOLUME(69),
  FULLSIZE(70),
  MAXIMIZE(71),
  IPTV_FRAME_ACTIVATED(72),
  MOUSE_EXITED(73),
  MOUSE_ENTERED(73),
  GROUPROOM(74),
  MODIFY(75),
  EXPIRY_DATE(76),
  REMAINING_MEMBERS(77),
  INVITE(78),
  PLUS_ONE_ODX(79),
  ODX_REPORT(80),
  MINUS_ONE_ODX(81),
  ODXMERGE(82),
  UPDATE(83),
  NEW_GAME(84),
  START_GAME(85),
  HOW_TO_USE(86),
  KNOPF_AUF_RUNDENZAHL(87),
  KNOPF_AUF_SUCHMUSTER_RECHTS(88),
  KNOPF_AUF_SUCHMUSTER_LINKS(89),
  GEWONNEN(90),
  VERLOREN(91),
  COLOR(92),
  MIKRO_AUFZEICHNEN(93),
  TITEL_ABSPIELEN(94),
  OHNE_REGISTRIEREN(95),
  SHARING(97),
  QUIT(100);

  private int value;

  Control(int value) {
    this.value = value;
  }



  public int value() {
    return value;
  }

}
