/**
 *  Copyright © 2020-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTreeUI;



public class JavacommTreeUI extends BasicTreeUI {

  private Color top, bottom;

  public JavacommTreeUI() {
    this(Color.WHITE, Color.BLACK);
  }



  @Override
  public void installUI(JComponent c) {
    super.installUI(c);
  }



  public JavacommTreeUI(Color color1, Color color2) {
    setBackgroundGradient(color1, color2);
  }



  public void setBackgroundGradient(Color color1, Color color2) {
    top = color1;
    bottom = color2;
  }



  @Override
  public void paint(Graphics g, JComponent c) {
    Graphics2D g2 = (Graphics2D) g;
    GradientPaint gp = new GradientPaint(0, 0, top, 0, tree.getHeight(), bottom);
    g2.setPaint(gp);
    g2.fillRect(0, 0, tree.getWidth(), tree.getHeight());
    super.paint(g, c);
  }

}
