/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

import net.javacomm.multilingual.Babelfish;

/**
 * Ein InternalFrame kann in den WindowManager eingehängt werden. Später wird er
 * dann als JTree in der rechten Fensterhälfte angezeigt.
 * 
 * 
 * @author llange
 *
 */
public interface WM extends Babelfish {

  /**
   * Der Frame wurde gerade aktiviert. Er hat den Fokus erhalten.
   * 
   */
  public void activated();

  /**
   * Die ID ist ein Klartext.
   *
   * @return die Frame-ID für den WindowManager
   */
  public String getFrameTitleId();

  /**
   * Um welchen Frametyp(Chat, Player, Phone etc.) handelt es sich?
   * 
   * @return Frametyp
   */
  public Frames getType();


  /**
   * 
   * Der Frame wird in den Window-Manager eingehängt.
   * 
   * @param frame
   *              ein JInternalFrame
   */
  public void insertWM(WM frame);

  /**
   * Ein Frame wird aus dem Window-Manager entfernt.
   * 
   * @param frame
   *              ein JInternalFrame
   */
  public void removeWM(WM frame);

  /**
   * Jeder Frame bekommt eine ID, mit der er im WindowManager hinterlegt ist.
   * Diese id erscheint im oberen Fensterrahmen.
   * 
   * @param id
   *           Klartext
   */
  public void setFrameTitleId(String id);

  /**
   * Jeder Frame gehört zu einem bestimmten Frametyp.
   * 
   * 
   * @param value
   *              der Frametyp wie Chat, Player, Phone etc.
   */
  public void setType(Frames value);


  /**
   * Jeder Frame hat eine eineindeutige Id.
   * 
   * @return ein Longwert
   */
  public long getId();

  /**
   * Der Knotenname in der Baumansicht. Meistens ist es der Frametitle.
   * 
   * @return der Knotenname
   */
  public String getBaumansicht();

}
