/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;



public class WindowAnrufen {

  private List<WindowAnrufenListener> windowAnrufenList = Collections
      .synchronizedList(new LinkedList<WindowAnrufenListener>());

  private String nickname;

  public WindowAnrufen() {}



  /**
   * Wer von 'Telefon Anrufen' benachrichtigt werden möchte, kann sich hier
   * registrieren.
   * 
   * @param listener
   */
  public void addWindowAnrufenListener(WindowAnrufenListener listener) {
    windowAnrufenList.add(listener);
  }



  public void removeWindowAnrufenListener(WindowAnrufenListener listener) {
    windowAnrufenList.remove(listener);
  }



  /**
   * Die Quelle für das Ereignis wird nicht vorgegeben.
   *
   *
   * @param event
   *              diese Quelle löste das Event aus
   */
  public void trigger(WindowAnrufenEvent event) {
    for (WindowAnrufenListener listener : windowAnrufenList) {
      listener.ringRing(event);
    }
  }



  /**
   * Diese Methode immer aufrufen, wenn die Telefonverbindung gerade zustande
   * gekommen ist. Erst danach das Ereignis mit
   * {@link #trigger(WindowAnrufenEvent)} auslösen. Der Nickname erscheint im
   * Fensterrahmen und in der Baumansicht.
   *
   * @param nickname
   */
  public void setTriggerNickname(String nickname) {
    this.nickname = nickname;
  }



  /**
   * Der Nickname erscheint im Fenstertitel und auf der rechten Seite in der
   * Baumansicht.
   *
   * @return Empfänger
   */
  public String getTriggerNickname() {
    return nickname;
  }

}
