/**
 *  Copyright © 2022-2025, Luis Andrés Lange <https://javacomm.net>
 *
 *  This Source Code Form is subject to the terms of the Mozilla Public
 *  License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *  ----------------------------------------------------------------------------
 *
 *  Exhibit B - "Incompatible With Secondary Licenses" Notice
 *
 *  This Source Code Form is "Incompatible With Secondary Licenses",
 *  as defined by the Mozilla Public License, v. 2.0.
 *
 */
package net.javacomm.window.manager;

import java.util.EventObject;
import net.javacomm.multilingual.schema.ISO639;



/**
 * Ein Telefonanruf wird gerade getätigt und kann den anderen Diensten in der
 * Fensterverwaltung mitgeteilt werden.
 * 
 * @author llange
 *
 */
@SuppressWarnings("serial")
public class WindowAnrufenEvent extends EventObject {

  private String nickname;
  private ISO639 code;

  /**
   * Das Ereignis wird von "Telefon anrufen" ausgelöst.
   * 
   * @param source
   *               hat das Ereignis ausgelöst
   */
  public WindowAnrufenEvent(Object source) {
    super(source);
  }



  /**
   * Der Nickname vom Empfänger.
   * 
   * @return ein Nickname
   */
  public String getNickname() {
    return nickname;
  }



  /**
   * Der Nickname vom Empfänger wird mit dem Ereignis verknüpft.
   * 
   * @param value
   *              ein Nickname
   */
  public void setNickname(String value) {
    nickname = value;
  }



  /**
   * Gib den Sprachcode zurück.
   * 
   * @return Sprachcode nach ISO-639
   */
  public ISO639 getCode() {
    return code;
  }



  /**
   * Der Sprachcode für die GUI-Komponente
   * 
   * @param code
   *             Sprachcode nach ISO-639
   */
  public void setCode(ISO639 code) {
    this.code = code;
  }

}
